// Mtodos inline da classe ApendiceCor:

inline Slang::ApendiceComCor::ApendiceComCor()
    : o_borda_(preto, branco),
      o_titulo_(vermelho, branco),
      o_itens_(preto, branco),
      o_corrente_(amarelo, azul) {
}

inline Slang::Ecra::ObjectoCor const& Slang::ApendiceComCor::o_borda() const {
    return o_borda_;
}

inline Slang::Ecra::ObjectoCor const& Slang::ApendiceComCor::o_titulo() const {
    return o_titulo_;
}

inline Slang::Ecra::ObjectoCor const& Slang::ApendiceComCor::o_itens() const {
    return o_itens_;
}

inline Slang::Ecra::ObjectoCor const& Slang::ApendiceComCor::o_corrente() const {
    return o_corrente_;
}

inline Slang::Ecra::ObjectoCor& Slang::ApendiceComCor::o_borda() {
    return o_borda_;
}

inline Slang::Ecra::ObjectoCor& Slang::ApendiceComCor::o_titulo() {
    return o_titulo_;
}

inline Slang::Ecra::ObjectoCor& Slang::ApendiceComCor::o_itens()    {
    return o_itens_;
}

inline Slang::Ecra::ObjectoCor& Slang::ApendiceComCor::o_corrente() {
    return o_corrente_;
}


// Mtodos inline da classe MenuComCor:

inline Slang::MenuComCor::MenuComCor(std::string const& titulo)
    : Menu(titulo) {
}


// Mtodos inline da classe Menu:

inline Slang::Menu::Menu(std::string const& titulo)
    : titulo_(titulo) {
}

inline Slang::Menu::~Menu() {
}

inline std::string Slang::Menu::titulo() const {
    return titulo_;
}

// Mtodos inline da classe MenuSimples:

inline Slang::MenuSimples::MenuSimples(std::string const& titulo, 
				       std::string const itens[], 
				       int numero_de_itens) 
    : MenuComCor(titulo),
      itens(itens, itens + numero_de_itens),
      numero_de_itens(numero_de_itens),
      corrente(0) {
    // Calcular dimenses:
    calculaDimensao();
    calculaPosicao();
}

inline void Slang::MenuSimples::calculaPosicao() const {
    posicao.linha((ecra.dimensao().linhas() - dimensao.linhas()) / 2);
    posicao.coluna((ecra.dimensao().colunas() - dimensao.colunas()) / 2);
}

inline void Slang::MenuSimples::desenhaItem(int i) const {
    ecra << (i == corrente ? o_corrente() : o_itens());
    ecra << cursor(posicao + Posicao(2 + i, 1)) 
	 << largura(largura_maxima) << itens[i];
    if(i == corrente)
	// Cursor a meio do item corrente:
	ecra << cursor(posicao + Posicao(2 + i, largura_maxima / 2));
}


// Mtodos inline da classe MenuCor:

inline Slang::MenuCor::MenuCor(string const& titulo)
    : MenuSimples(titulo, nomes_das_cores, numero_de_cores) {
}


// Mtodos inline da classe MenuSimNao:
inline Slang::MenuSimNao::MenuSimNao(string const& titulo)
    : MenuSimples(titulo, "Sim\nNo") {
}

inline int Slang::MenuSimNao::executa() {
    return !MenuSimples::executa();
}


// Mtodos inline da classe Aviso:

inline Slang::Aviso::Aviso(string const& titulo)
    : menu(titulo, "T bem...") {
}

inline Slang::Aviso::~Aviso() {
}

inline void Slang::Aviso::executa() {
    menu.executa();
}


// Mtodos inline da classe 

inline Slang::CaixaDeTexto::CaixaDeTexto(std::string const& titulo,
					 std::string const& valor,
					 std::string::size_type espacos_)
    : titulo_(titulo), espacos(max(espacos_,titulo.length())), valor(valor), 
      inicio(valor.length() < espacos? 0 : valor.length() - espacos + 1),
      posicao(valor.length() - inicio), 
      dimensao(4, espacos + 2) {
    calculaPosicao();
}

inline Slang::CaixaDeTexto::~CaixaDeTexto() {
}

inline std::string Slang::CaixaDeTexto::titulo() const {
    return titulo_;
}

inline void Slang::CaixaDeTexto::calculaPosicao() const {
    origem.linha((ecra.dimensao().linhas() - dimensao.linhas()) / 2);
    origem.coluna((ecra.dimensao().colunas() - dimensao.colunas()) / 2);
}


