#ifndef SLANG_SLANG_H
#define SLANG_SLANG_H

#include <Slang/ecra.H>
#include <Slang/teclado.H>
#include <Slang/menu.H>
#include <Slang/util.H>

/**
Este espao nominativo envolve todas as ferramentas da biblioteca Slang++.

A biblioteca Slang++ permite a utilizao de algumas funes que actuam sobre
o teclado e o ecr e a criao de menus simples em modo texto.  A biblioteca
consiste de um pacote #Slang# (representado pelo espao nominativo #Slang#)
dividido em quatro mdulos fisicos #teclado#, #ecra#, #menu# e #util#, cada um 
com o correspondente ficheiro de interface (#Slang/teclado.H#,
#Slang/ecra.H#, #Slang/menu.H# e #Slang/util.H#).

Esto definidas nesta biblioteca as variveis globais #teclado# (do tipo
#Slang::Teclado#) e #ecra# (do tipo #Slang::Ecra#), no sendo por isso
necessrio criar quaisquer variveis destes tipos.

Nesta documentao omite-se o prefixo #Slang::# sempre que conveniente para
facilitar a leitura, embora em rigor este seja necessrio.

Para construir um programa (neste caso #teste_slang.C#) que utilize estas
biblioteca deve dar o seguinte comando:
\begin{verbatim}
c++ -Wall -ansi -pedantic -g -o teste_slang teste_slang.C -lSlang++ -lslang 
\end{verbatim}

Os ficheiros fonte devem incluir o ficheiro de interface #Slang/slang.H#, que
por sua vez inclui os ficheiros de interface dos quatro mdulos, ou incluir
apenas o ficheiro de interface do mdulo pretendido. 

Sempre que se testar algum programa que use a biblioteca Slang++ deve-se usar
uma consola #xterm# (outras consolas podem gerar alguns problemas). Para
lanar uma consola #xterm# deve-se dar o comando:
\begin{verbatim}
xterm& 
\end{verbatim}
numa consola normal (#Konsole#). 

Pode-se tambm fazer 'alt-F2' e escrever #xterm# na caixa de dilogo que surge
no ecr.

Caso se pretenda instalar esta biblioteca noutro computador deve-se fazer o
seguinte:
\begin{enumerate}
\item Importar os seguintes ficheiros: 
\begin{itemize}
\item \URL[slang-1.4.0-2.i386.rpm]{http://www.iscte.pt/programacao/p2/trabalhos/slang-1.4.0-2.i386.rpm}
\item \URL[slang-devel-1.4.0-2.i386.rpm]{http://www.iscte.pt/programacao/p2/trabalhos/slang-devel-1.4.0-2.i386.rpm}
\item \URL[Slang++-0.1.tar.gz]{http://www.iscte.pt/programacao/p2/trabalhos/Slang++-0.1.tar.gz}
\end{itemize}

Para importar no netscape basta fazer 'shift-clique' no boto esquerdo do
rato.

\item Dar os seguintes comandos: 
\begin{verbatim}
tar -zxf Slang++-0.1.tar.gz 
cd Slang++ 
make 
su (inserir a senha [password] de administrao da mquina) 
cd .. 
rpm -Uhv slang.*.rpm 
exit
\end{verbatim}
\end{enumerate}
 */
namespace Slang {
}

#endif // SLANG_SLANG_H
