#include <cassert>

extern "C" {
#include <slang/slang.h>
}

// Definio de mtodos inline da classe Tecla:

inline Slang::Tecla::Tecla(TeclaEnum tecla) 
    : tecla(tecla) {
}

inline Slang::Tecla::operator Slang::Tecla::TeclaEnum () const {
    return tecla;
}

inline char Slang::Tecla::comoChar() const {
    assert(caractere());
    return char(tecla);
}

inline bool Slang::Tecla::deslocamento() const {
    return tecla == cima || tecla == baixo || tecla == esquerda || 
	tecla == direita;
}

inline bool Slang::Tecla::caractere() const {
    return tecla < 256;
}

// Definio de mtodos inline da classe Teclado:

inline Slang::Teclado::~Teclado()  {
    // Terminao do slang:
    SLang_reset_tty();
}

inline bool Slang::Teclado::teclaDisponivel(int decimos_de_segundo) const {
    return SLang_input_pending(decimos_de_segundo) != 0;
}

inline Slang::Tecla Slang::Teclado::tecla() {
    return Tecla::TeclaEnum(SLkp_getkey());
}

inline void Slang::Teclado::limpa() {
     SLang_flush_input();
}

