#include <Slang/ecra.H>

#include <Slang/util.H>


// Definio de mtodos de Posicao:

void Slang::Posicao::carrega(std::istream& entrada) 
{
    if(!(entrada >> linha_ >> Slang::il >> coluna_ >> Slang::il))
	throw ErroAoCarregar("Posicao");
}

void Slang::Posicao::guarda(std::ostream& saida) const
{
    if(!(saida << linha_ << endl << coluna_ << endl))
	throw ErroAoGuardar("Posicao");
}


// Definio de mtodos de Dimensao:

void Slang::Dimensao::carrega(std::istream& entrada) 
{
    if(!(entrada >> linhas_ >> Slang::il >> colunas_ >> Slang::il))
	throw ErroAoCarregar("Dimensao");
}

void Slang::Dimensao::guarda(std::ostream& saida) const
{
    if(!(saida << linhas_ << endl << colunas_ << endl))
	throw ErroAoGuardar("Dimensao");
}


// Definio de mtodos de Caixa:

void Slang::Caixa::carrega(std::istream& entrada) 
{
    origem_.carrega(entrada);
    dimensao_.carrega(entrada);
}

void Slang::Caixa::guarda(std::ostream& saida) const
{
    origem_.guarda(saida);
    dimensao_.guarda(saida);
}


// Operadores de leitura e escrita de cores!
std::ostream& Slang::operator << (std::ostream& saida, Slang::Cor cor) 
{
    return saida << Slang::nomes_das_cores[cor];
}

std::istream& Slang::operator >> (std::istream& entrada, Slang::Cor& cor) 
{
    string nome;
    if(entrada >> nome) {
	for(int c = Slang::primeira_cor; c != Slang::numero_de_cores; ++c)
	    if(Slang::nomes_das_cores[c] == nome) {
		cor = Slang::Cor(c);
		return entrada;
	    }
	entrada.clear(ios::badbit); // devia ser ios_base::badbit
    }
    return entrada;
}


// Definio de mtodos de classe de Ecra:

Slang::Ecra::Ecra(Cor texto, Cor fundo, bool limita_cursor)
    : limita_cursor(limita_cursor), redimensionado_(true),
      para_no_proximo(false), largura_do_proximo(0), ocupacao_objecto(256) {

    assert(!existe_instancia);

    existe_instancia = true;
    // Inicializaes do slang:
    SLtt_get_terminfo();
    if(SLsmg_init_smg() == -1) {
	// Que fazer?
    }
    // Inicializao do manipulador de mudanas no ecr:
    SLsignal(SIGWINCH, manipuladorTamanhoMudou);
    atributos(texto, fundo);
}

Slang::Ecra::Troco Slang::Ecra::copia(Caixa const& caixa) const 
{
    verificaTamanho();

    // Guardar cursor inicial:
    Posicao const posicao_original_do_cursor = cursor();

    int const linha = caixa.origem().linha(); 
    int const coluna = caixa.origem().coluna();
    int const linhas = caixa.dimensao().linhas();
    int const colunas = caixa.dimensao().colunas();

    Troco troco(caixa.dimensao());
    int i = 0;
    for(int l = linha; l != linha + linhas; ++l)
	for(int c = coluna; c != coluna + colunas; ++c)
	{
	    cursor(Posicao(l, c));
	    troco.dados[i++] = SLsmg_char_at();
	}

    // Regressar ao cursor inicial:
    cursor(posicao_original_do_cursor);

    return troco;
}

void Slang::Ecra::cola(Troco const& troco, Posicao const& posicao)
{
    verificaTamanho();

    // Guardar cursor inicial:
    Posicao posicao_original_do_cursor;
    if(para_no_proximo)
	posicao_original_do_cursor = cursor();

    // Afazer: devia-se guardar tambm o objecto da prxima escrita...

    int const linha = posicao.linha();
    int const coluna = posicao.coluna();
    int const linhas = troco.dimensao().linhas();
    int const colunas = troco.dimensao().colunas();

    int i = 0;
    for(int l = linha; l != linha + linhas; ++l)
	for(int c = coluna; c != coluna + colunas; ++c)
	{
	    cursor(Posicao(l, c));
	    char const caractere = troco.dados[i] & 0XFF;
	    int const objecto = troco.dados[i++] >> 8;
	    SLsmg_set_color(objecto);
	    SLsmg_write_char(caractere);
	}

    // Regressar ao cursor inicial:
    if(para_no_proximo) {
	cursor(posicao_original_do_cursor);
	para_no_proximo = false;
    }

    // Em vez de regressar ao objecto da prxima escrita (Afazer:
    // melhorar no futuro), pe-se o fundo:
    *this << fundo;
}

Slang::Ecra& Slang::Ecra::operator << (string const& s)
{
    verificaTamanho();

    Posicao posicao_original_do_cursor;
    if(para_no_proximo)
	posicao_original_do_cursor = cursor();

    if(largura_do_proximo == 0)
	SLsmg_write_string(const_cast<char *>(s.c_str()));
    else {
	SLsmg_write_nstring(const_cast<char *>(s.c_str()), 
			    largura_do_proximo);
	largura_do_proximo = 0;
    }
    // Usar const_cast  violento, mas a verdade  que p
    // SLsmg_write_string deveria declarar parmetro como char const*

    if(para_no_proximo) {
	cursor(posicao_original_do_cursor);
	para_no_proximo = false;
    }

    return *this;
}

Slang::Ecra const& Slang::Ecra::operator >> (Troco& troco) const
{
    verificaTamanho();

    Posicao const posicao_original_do_cursor = cursor();

    int const linha = posicao_original_do_cursor.linha();
    int const coluna = posicao_original_do_cursor.coluna();
    int const linhas = troco.dimensao().linhas();
    int const colunas = troco.dimensao().colunas();

    int i = 0;
    for(int l = linha; l != linha + linhas; ++l)
	for(int c = coluna; c != coluna + colunas; ++c) {
	    cursor(Posicao(l, c));
	    troco.dados[i++] = SLsmg_char_at();
	}

    cursor(posicao_original_do_cursor);

    return *this;
}

void Slang::Ecra::verificaTamanho() const
{
    if(tamanho_mudou)
    {
	// A varivel tamanho_mudou passa a falso.  Ela  colocada a
	// true pelo manipulador do sinal SIGWINCH!
	tamanho_mudou = false;

	// Como o ecr mudou de tamanho, pe-se a true a varivel
	// redimensionado_, para que os clientes do ecr possam
	// redesenhar o que for necessrio (tipicamente tudo):
	redimensionado_ = true;

	// Guarda-se a antiga posio do cursor:
	Posicao const posicao_do_cursor = cursor();

	// Obter nova dimenso do ecr e reinicializar o slang smg:
	SLtt_get_screen_size();
	SLsmg_reinit_smg();	// a posio do cursor perde-se aqui...

	// Colocar de novo o cursor onde estava:
	cursor(posicao_do_cursor);
    }
}

int Slang::Ecra::reservaObjecto()
{
    int objecto = 1;
    int ocupacao_minima = ocupacao_objecto[1];
    for(int o = 2; o != 256; ++o)
	if(ocupacao_objecto[o] < ocupacao_minima) {
	    ocupacao_minima = ocupacao_objecto[o];
	    objecto = o;
	}
    ++ocupacao_objecto[objecto];
    return objecto;
}


// Definio de mtodos de classe de Ecra:

void Slang::Ecra::manipuladorTamanhoMudou(int sinal)
{
    Slang::Ecra::tamanho_mudou = true;
    SLsignal(SIGWINCH, manipuladorTamanhoMudou);
}


// Definio de variveis de classe de Ecra:

bool Slang::Ecra::existe_instancia = false;

bool volatile Slang::Ecra::tamanho_mudou = false;

char* Slang::Ecra::nome_de_cor[numero_de_cores] = {
    "black",
    "gray",
    "red",
    "brightred",
    "green",
    "brightgreen",
    "brown",
    "yellow",
    "blue",
    "brightblue",
    "magenta",
    "brightmagenta",
    "cyan",
    "brightcyan",
    "lightgray",
    "white"
};


// Definio de variveis globais:

string const Slang::nomes_das_cores[numero_de_cores] = {
    "preto",
    "cinza",
    "vermelho",
    "vermelho-brilhante",
    "verde",
    "verde-brilhante",
    "castanho",
    "amarelo",
    "azul",
    "azul-brilhante",
    "magenta",
    "magenta-brilhante",
    "ciano",
    "ciano-brilhante",
    "cinzento-claro",
    "branco"
};

Slang::Ecra Slang::ecra;
