#include <Slang/menu.H>

#include <Slang/teclado.H>

#include <cctype>

using namespace std;


// Mtodos no inline da classe MenuSimples:

Slang::MenuSimples::MenuSimples(string const& titulo, 
				string const& itens_juntos) 
    : MenuComCor(titulo), corrente(0)
{
    // itens_juntos tem todos os itens separados por \n.  Obt-los todos
    // separados:
    string::size_type inicio = 0;
    string::size_type fim;
    while((fim = itens_juntos.find('\n', inicio)) != string::npos) {
	if(fim - inicio != 0)
	    // Itens vazios no se pem...
	    itens.push_back(itens_juntos.substr(inicio, fim - inicio));
	inicio = fim + 1;
    }
    // Ainda pode haver um, se a ltima linha no terminou em '\n'!
    if(inicio < itens_juntos.length())
	itens.push_back(itens_juntos.substr(inicio));

    numero_de_itens = int(itens.size());
    
    calculaDimensao();
    calculaPosicao();
}

void Slang::MenuSimples::calculaDimensao()
{
    largura_maxima = titulo().length();
    for(int i = 0; i != numero_de_itens; ++i)
	if(largura_maxima < itens[i].size())
	    largura_maxima = itens[i].size();
    dimensao.linhas(numero_de_itens + 3);
    dimensao.colunas(largura_maxima + 2);
}

int Slang::MenuSimples::executa() 
{
    // Copiar ecr sem menu (Afazeres: copiar apenas parte afectada pelo
    // menu!):
    Ecra::Troco troco = ecra.copia();
    // Guardar posio do cursor:
    Posicao c = ecra.cursor();
    
    desenha();
    desenhaItem(corrente);
    ecra << refresca;
    while(true) {
	if(ecra.redimensionado()) {
	    calculaPosicao();
	    ecra.cola(troco);
	    desenha();
	    desenhaItem(corrente);
	    ecra << refresca;
	}
	if(teclado.teclaDisponivel(1))
	    switch(teclado.tecla()) {
	      case Tecla::entrada:
		// Volta ao normal:
		ecra.cola(troco);
		ecra << c << fundo << refresca;
		return corrente;
	      case Tecla::cima:
		if(corrente != 0) {
		    --corrente;
		    desenhaItem(corrente + 1);
		    desenhaItem(corrente);
		    ecra << refresca;
		}
		break;
	      case Tecla::baixo:
		if(corrente != numero_de_itens - 1) {
		    ++corrente;
		    desenhaItem(corrente - 1);
		    desenhaItem(corrente);
		    ecra << refresca;
		}
		break;
	      default:
		break;
	    }
    }
}

void Slang::MenuSimples::desenha() const 
{
    // Desenhar caixa:
    ecra << o_borda() << caixa(posicao, dimensao);

    // Desenhar titulo:
    ecra << o_titulo() << cursor(posicao + Posicao(1, 1)) 
	 << largura(largura_maxima) << titulo();
	
    // Desenhar itens:
    ecra << o_itens();
    for(int i = 0; i != numero_de_itens; ++i)
	ecra << cursor(posicao + Posicao(2 + i, 1)) 
	     << largura(largura_maxima) << itens[i];
}


// Mtodos no inline da classe CaixaDeTexto:

std::string Slang::CaixaDeTexto::executa(bool impede_vazia)
{
    // Copiar ecr sem menu (Afazeres: copiar apenas parte afectada pelo
    // menu!):
    Ecra::Troco troco = ecra.copia();
    // Guardar posio do cursor:
    Posicao c = ecra.cursor();
    
    desenha();
    ecra << refresca;
    while(true) {
	if(ecra.redimensionado()) {
	    calculaPosicao();
	    ecra.cola(troco);
	    desenha();
	    ecra << refresca;
	}
	if(teclado.teclaDisponivel(1)) {
	    Tecla tecla = teclado.tecla();
	    switch(tecla) {
	      case Tecla::entrada:
		if(!impede_vazia || valor.length() != 0) {
		    // Volta ao normal:
		    ecra.cola(troco);
		    ecra << c << fundo << refresca;
		    return valor;
		}
		break;
	      case Tecla::esquerda:
		if(posicao > 0)
		    --posicao;
		else if(inicio > 0)
		    --inicio;
		desenha();
		ecra << refresca;
		break;
	      case Tecla::direita:
		if(posicao < valor.length() - inicio)
		    if(posicao < espacos - 1)
			++posicao;
		    else
			++inicio;
		desenha();
		ecra << refresca;
		break;
	      case Tecla::apaga:
		if(inicio + posicao < valor.length())
		    valor.erase(inicio + posicao, 1);
		desenha();
		ecra << refresca;
		break;
	      case Tecla::apaga_para_tras:
		if(inicio + posicao > 0) {
		    if(posicao > 0)
			--posicao;
		    else
			--inicio;
		    valor.erase(inicio + posicao, 1);
		}
		desenha();
		ecra << refresca;
		break;
	      case Tecla::casa:
		posicao = 0;
		inicio = 0;
		desenha();
		ecra << refresca;
		break;
	      case Tecla::fim:
		if(valor.length() - inicio < espacos)
		    posicao = valor.length() - inicio;
		else {
		    posicao = espacos - 1;
		    inicio = valor.length() - espacos + 1;
		}
		desenha();
		ecra << refresca;
		break;
	    }
	    if(tecla.caractere() && isprint(tecla.comoChar())) {
		valor.insert(inicio + posicao, 1, tecla.comoChar());
		if(posicao < espacos - 1)
		    ++posicao;
		else
		    ++inicio;
		desenha();
		ecra << refresca;
	    }
	}
    }
}

void Slang::CaixaDeTexto::desenha() const 
{
    // Desenhar caixa:
    ecra << o_borda() << caixa(origem, dimensao);

    // Desenhar titulo:
    ecra << o_titulo() << cursor(origem + Posicao(1, 1)) 
	 << largura(espacos) << titulo();
	
    // Desenhar valor:
    ecra << o_corrente();
    ecra << cursor(origem + Posicao(2, 1)) 
	 << largura(espacos) << valor.substr(inicio) 
	 << cursor(origem + Posicao(2, 1 + posicao));
}


// Programa de teste:

#ifdef TESTE

using namespace Slang;

extern "C" {
#include <unistd.h>
}

int main()
{
    /*
    string valor = CaixaDeTexto("O seu nome :",
				"Manuel Menezes de Sequeira",
				5).executa(true);
    ecra << cursor(0, 0) << valor << refresca;
    sleep(3);*/
    ecra << cursor(1, 0) 
	 << MenuSimNao("Sim ou no, eis a questo...").executa()
	 << refresca;
    sleep(3);
}

#endif
