#include "pilha_de_int.H"

PilhaDeInt::PilhaDeInt(PilhaDeInt const& original)
    : capacidade_actual(original.capacidade_actual),
      itens(new Item[capacidade_actual]),
      numero_de_itens(original.numero_de_itens)
{
    // Copia os itens:
    for(int i = 0; i != numero_de_itens; ++i)
       itens[i] = original.itens[i];

    assert(cumpreInvariante());
}

PilhaDeInt& PilhaDeInt::operator=(PilhaDeInt const& modelo)
{
    assert(cumpreInvariante());

    if(this != &modelo) {
	if(capacidade_actual == modelo.capacidade_actual) {
	   capacidade_actual = modelo.capacidade_actual;
	   delete[] itens;
	   itens = new Item[capacidade_actual];
	}
	numero_de_itens = modelo.numero_de_itens;

	for(int i = 0; i != numero_de_itens; ++i)
	    itens[i] = modelo.itens[i];
    }

    assert(cumpreInvariante());

    return *this;
}

void PilhaDeInt::poe(Item const& novo_item)
{
    assert(cumpreInvariante());

    if(numero_de_itens == capacidade_actual) {
	capacidade_actual *= 2;

	Item* const novos_itens = new Item[capacidade_actual];

	for(int i = 0; i != numero_de_itens; ++i)
	    novos_itens[i] = itens[i];

	delete[] itens;

	itens = novos_itens;
    }

    itens[numero_de_itens] = novo_item;
    ++numero_de_itens;

    assert(cumpreInvariante());
}


#ifdef TESTE

int main()
{
    int const n = 10000;
    PilhaDeInt pilha;

    assert(pilha.estaVazia());
    assert(pilha.altura() == 0);

    for(int i = 0; i != n; ++i) {
	assert(pilha.altura() == i);
	pilha.poe(i);
	assert(pilha.topo() == i);
    }

    assert(not pilha.estaVazia());
    assert(pilha.altura() == n);

    PilhaDeInt outra_pilha = pilha;

    assert(not outra_pilha.estaVazia());
    assert(outra_pilha.altura() == n);

    for(int i = n - 1; i != -1; --i) {
	assert(pilha.topo() == i);
	pilha.tiraItem();
	assert(pilha.altura() == i);
    }

    assert(pilha.estaVazia());
    assert(pilha.altura() == 0);

    assert(not outra_pilha.estaVazia());
    assert(outra_pilha.altura() == n);

    for(int i = n - 1; i != -1; --i) {
	assert(outra_pilha.topo() == i);
	outra_pilha.tiraItem();
	assert(outra_pilha.altura() == i);
    }

    assert(pilha.estaVazia());
    assert(pilha.altura() == 0);

    pilha.poe(11);

    PilhaDeInt const pilha_constante = pilha;

    assert(pilha_constante.altura() == 1);
    assert(not pilha_constante.estaVazia());
    assert(pilha_constante.topo() == 11);
}

#endif // TESTE
