#ifndef PILHA_DE_INT_H

#define PILHA_DE_INT_H

/** Representa pilhas de int.
    @invariant itens aponta matriz com capacidade_actual itens e
	       capacidade_inicial <= capacidade_actual e
	       0 <= nmero_de_itens <= capacidade_actual. */
class PilhaDeInt {
  public:
    typedef double Item;

    /** Constri pilha vazia.
	@pre V.
	@post estaVazia(). */
    PilhaDeInt();

    /** Construtor por cpia.
	@pre V.
	@post *this = original. */
    PilhaDeInt(PilhaDeInt const& original);

    /** Destri a pilha.
	@pre V.
	@post recursos externos reservados foram libertados. */
    ~PilhaDeInt();

    /** Atribuio por cpia.
	@pre V.
	@post *this = modelo. */
    PilhaDeInt& operator=(PilhaDeInt const& modelo);

    /** Indica se a pilha est vazia.
	@pre V.
	@post estaVazia = *this est vazia. */
    bool estaVazia() const;

    /** Devolve altura da pilha.
	@pre V.
	@post altura = altura de *this. */
    int altura() const;

    /** Devolve o item que est no topo da pilha.
	@pre estaVazia().
	@post topo idntico ao item no topo de *this. */
    Item const& topo() const;

    /** Devolve o item que est no topo da pilha.
	@pre estaVazia().
	@post topo idntico ao item no topo de *this. */
    Item& topo();

    /** Pe um novo item na pilha (no topo).
	@pre V.
	@post *this contm um item adicional no topo igual a novo_item. */
    void poe(Item const& novo_item);

    /** Tira o item que est no topo da pilha.
	@pre estaVazia().
	@post *this contm os itens originais menos o do topo. */
    void tiraItem();

  private:
    static int const capacidade_inicial = 32;
    int capacidade_actual;
    Item* itens;
    int numero_de_itens;

    /** Indica se a pilha verifica a condio invariante da classe.
	@pre V.
	@post cumpreInvariante = (itens <> 0 e
	      capacidade_inicial <= capacidade_actual e
	      0 <= nmero_de_itens <= capacidade_actual). */
    bool cumpreInvariante() const;
};

#include "pilha_de_int_impl.H"

#endif // PILHA_DE_INT_H
