#include <cassert>

inline PilhaDeInt::PilhaDeInt()
    : capacidade_actual(capacidade_inicial),
      itens(new Item[capacidade_actual]),
      numero_de_itens(0)
{

    assert(cumpreInvariante());
}

inline PilhaDeInt::~PilhaDeInt()
{
    assert(cumpreInvariante());

    delete[] itens;
}

inline bool PilhaDeInt::estaVazia() const
{
    assert(cumpreInvariante());

    return altura() == 0;
}

inline int PilhaDeInt::altura() const
{
    assert(cumpreInvariante());

    return numero_de_itens;
}

inline PilhaDeInt::Item const& PilhaDeInt::topo() const
{
    assert(cumpreInvariante());
    assert(not estaVazia());

    return itens[numero_de_itens - 1];
}

inline PilhaDeInt::Item& PilhaDeInt::topo()
{
    assert(cumpreInvariante());
    assert(not estaVazia());

    return itens[numero_de_itens - 1];
}

inline void PilhaDeInt::tiraItem()
{
    assert(cumpreInvariante());
    assert(not estaVazia());

    --numero_de_itens;

    assert(cumpreInvariante());
}

inline bool PilhaDeInt::cumpreInvariante() const
{
    return itens != 0 and
	   capacidade_inicial <= capacidade_actual and
	   0 <= numero_de_itens <= capacidade_actual;
}
