#include <cassert>
#include <iostream>

inline Filme::Filme(std::string const& nome, 
		    std::string const& realizador,
		    int duracao)
    :nome_(nome), realizador_(realizador), duracao_(duracao) 
{
    assert(0 <= duracao);

    assert(cumpreInvariante());
}

inline std::string const& Filme::nome() const 
{
    assert(cumpreInvariante());

    return nome_;
}

inline std::string const& Filme::realizador() const 
{
    assert(cumpreInvariante());

    return realizador_;
}

inline int Filme::duracao() const 
{
    assert(cumpreInvariante());

    return duracao_;
}

inline void Filme::mostraEm(std::ostream& saida) const 
{
    assert(cumpreInvariante());

    saida << "Nome:\t\t" << nome() << std::endl
	  << "Realizador:\t" << realizador() << std::endl
	  << "Duracao:\t" << duracao() << std::endl;
}

inline bool Filme::cumpreInvariante() const
{
    return 0 <= duracao_;
}
