#include <iostream>
#include <fstream>
#include <list>

#include <Erros/erros.H>

#include "filme.H"
#include "outros_filmes.H"

using namespace std;

int main() 
try {
    cout << "Filmes construdos a partir de ficheiro: " << endl;

    ifstream entrada("filmes.txt");

    Filme filme(entrada);
    FilmeEstrangeiro filme_estrangeiro(entrada);
    EdicaoDoRealizador edicao_do_realizador(entrada);

    filme.mostraEm(cout);
    filme_estrangeiro.mostraEm(cout);
    edicao_do_realizador.mostraEm(cout);

    entrada.close();

    cout << endl
	 << "Filmes construdos directamente: " << endl;

    Filme novo_filme("Aniki Bb", "Manoel de Oliveira", 102);
    FilmeEstrangeiro novo_filme_estrangeiro("Dancer in the Dark", 
					    "Lars von Trier", 140,
					    "Dinamarca", "Ingls");
    EdicaoDoRealizador nova_edicao_do_realizador("Idi i smotri (Vem e v)",
						 "Elem Klimov", 142, 
						 "Nenhumas...");

    novo_filme.mostraEm(cout);
    novo_filme_estrangeiro.mostraEm(cout);
    nova_edicao_do_realizador.mostraEm(cout);

    cout << endl
	 << "Filmes carregados a partir de ficheiro: " << endl;

    entrada.open("filmes.txt");

    novo_filme.carregaDe(entrada);
    novo_filme_estrangeiro.carregaDe(entrada);
    nova_edicao_do_realizador.carregaDe(entrada);

    novo_filme.mostraEm(cout);
    novo_filme_estrangeiro.mostraEm(cout);
    nova_edicao_do_realizador.mostraEm(cout);

    cout << endl
	 << "Filmes dinmicos em lista: " << endl;

    list<Filme*> lista_de_filmes;

    lista_de_filmes.push_back(new Filme("Aniki Bb", 
					"Manoel de Oliveira", 
					102));
    lista_de_filmes.push_back(new FilmeEstrangeiro("Dancer in the Dark", 
						   "Lars von Trier", 140,
						   "Dinamarca", "Ingls"));
    lista_de_filmes.push_back(new EdicaoDoRealizador("Idi i smotri (Vem e v)",
						     "Elem Klimov", 142, 
						     "Nenhumas..."));
    
    for(list<Filme*>::iterator i = lista_de_filmes.begin(); 
	i != lista_de_filmes.end(); ++i)
	(*i)->mostraEm(cout);
			      
} catch(Erros::Erro& erro) {
    cerr << string(erro) << endl;
}

