#include <iostream>
#include <fstream>
#include <string>
#include <cassert>

using namespace std;

int const nota_minima_de_aprovacao = 10;
int const nota_maxima = 20;

class Aluno {
  public:
    Aluno(string const& nome, int const numero, int const nota = nota_maxima);
  
    string const& nome() const;
    int numero() const;
    int nota() const;

    void mudaNomePara(string const& novo_nome);
    void mudaNumeroPara(int novo_numero);
    void mudaNotaPara(int nova_nota);

private:
    string nome_;
    int numero_;
    int nota_;

    bool cumpreInvariante() const;
};

inline bool ePositiva(int const nota)
{
    return nota_minima_de_aprovacao <= nota;
}

inline Aluno::Aluno(string const& nome, int const numero,
                    int const nota)
    : nome_(nome), numero_(numero), nota_(nota) 
{
    assert(0 <= nota and nota <= nota_maxima and 0 <= numero);

    assert(cumpreInvariante());
}

inline string const& Aluno::nome() const 
{
    assert(cumpreInvariante());

    return nome_;
}

inline int Aluno::numero() const 
{
    assert(cumpreInvariante());

    return numero_;
}

inline int Aluno::nota() const 
{
    assert(cumpreInvariante());

    return nota_;
}

inline void Aluno::mudaNomePara(string const& novo_nome) 
{
    assert(cumpreInvariante());

    nome_ = novo_nome;

    assert(cumpreInvariante());
}

inline void Aluno::mudaNumeroPara(int const novo_numero) 
{
    assert(cumpreInvariante());
    assert(0 <= novo_numero);

    numero_ = novo_numero;

    assert(cumpreInvariante());
}

inline void Aluno::mudaNotaPara(int const nova_nota) 
{
    assert(cumpreInvariante());
    assert(0 <= nova_nota and nova_nota <= nota_maxima);

    nota_ = nova_nota;

    assert(cumpreInvariante());
}

inline bool Aluno::cumpreInvariante() const
{
    return 0 <= nota_ and nota_ <= nota_maxima and 0 <= numero_;
}

inline ostream& operator<<(ostream& saida, Aluno const& aluno) 
{
    return saida << aluno.nome() << ' ' << aluno.numero() << ' '
                 << aluno.nota();
}

istream& operator>>(istream& entrada, Aluno& aluno) 
{
    int novo_numero, nova_nota;
    string novo_nome;
    entrada >> novo_nome >> novo_numero >> nova_nota;

    if(not entrada.fail())
	if(0 <= nova_nota and nova_nota <= nota_maxima and 0 <= novo_numero)
	    aluno = Aluno(novo_nome, novo_numero, nova_nota);
	else
	    entrada.setstate(ios_base::failbit);

    return entrada;
}

int main() 
{
    ofstream canal_para_escrever_a_pauta("pauta.txt");

    Aluno manelito("Manelito", 17);

    canal_para_escrever_a_pauta << manelito;
    canal_para_escrever_a_pauta.close();

    ifstream canal_para_ler_a_pauta("pauta.txt");

    Aluno manelito_guardado("Z Ningum", 0);

    canal_para_ler_a_pauta >> manelito_guardado;

    assert(manelito.numero() == manelito_guardado.numero() and
	   manelito.nome() == manelito_guardado.nome() and
	   manelito.nota() == manelito_guardado.nota());
}
