#include "funcionario.H"

#include <cassert>

inline Funcionario::Funcionario(Cargo const cargo, int const identificacao)
    : identificacao_(identificacao), cargo_(cargo) 
{

    assert(cumpreInvariante());
}

inline int Funcionario::identificacao() const 
{
    assert(cumpreInvariante());

    return identificacao_;
}

int Funcionario::salario() const 
{
    assert(cumpreInvariante());

    int salario;
    
    if(cargo_ == administrativo)
        salario = salario_de_administrativo;
    else
        salario = salario_de_colaborador;

#ifdef COM_AJUDAS_DE_CUSTO
    salario += ajudas_de_custo;
#endif

    return salario;
}

int main() 
{
    Funcionario ferdinando(administrativo, 666);

    int salario = ferdinando.salario();

    // ...
}
