#include "lista_de_telefonema.H"

void ListaDeTelefonema::poeNaFrente(Item const& novo_item)
{
    assert(cumpreInvariante());

    // S se pode inserir se ainda houver espao:
    assert(not estaCheia());

    // Inserir na frente implica rearranjar todos os itens j na lista:
    for(int i = comprimento(); i != 0; --i)
	itens[i] = itens[i - 1];

    // Agora j h espao:
    itens[0] = novo_item;

    // E convm incrementar o contador de itens...
    ++numero_de_itens;

    assert(cumpreInvariante());
}

void ListaDeTelefonema::insereAntes(Iterador& iterador, Item const& novo_item)
{
    assert(cumpreInvariante());

    // S se pode inserir se ainda houver espao:
    assert(not estaCheia());

    // No se pode inserir antes se o iterador referir o item inicial:
    assert(iterador != inicio());

    // H que rearranjar todos os itens a partir do referenciado pelo iterador:
    for(int i = comprimento(); i != iterador.indice_do_item_referenciado; --i)
	itens[i] = itens[i - 1];

    // Agora j h espao (no esquecer de revalidar o iterador!):
    itens[iterador.indice_do_item_referenciado] = novo_item;

    ++iterador.indice_do_item_referenciado;

    // Mais um...
    ++numero_de_itens;

    assert(cumpreInvariante());
}

void ListaDeTelefonema::tiraDaFrente()
{
    // A completar ...
}

void ListaDeTelefonema::remove(Iterador& iterador)
{
    // A completar ...
}

std::ostream& operator<<(std::ostream& saida, ListaDeTelefonema& lista)
{
    saida << '(';
    for(ListaDeTelefonema::Iterador i = lista.primeiro(); i != lista.fim();
	++i)
    {
	saida << i.item();
	if(i != lista.ultimo())
	    saida << ",";
    }
    return saida << ')';
}


#ifdef TESTE

#include <iostream>
#include <fstream>

using namespace std;

/** Teste de unidade do TAD ListaDeTelefonemas.	 Verifica o bom
    funcionamento de todas as operaes sem excepo! */
int main()
{
    ListaDeTelefonema lista;

    assert(lista.comprimento() == 0);

    lista.poeNaFrente(Telefonema("2", 12));
    lista.poeAtras(Telefonema("3", 123));
    lista.poeNaFrente(Telefonema("1", 1));
    lista.poeAtras(Telefonema("4", 1234));

    assert(lista.comprimento() == 4);

    assert(lista.frente() == Telefonema("1", 1));
    assert(lista.tras() == Telefonema("4", 1234));

    // No se pode reaproveitar os iteradores, pois no so
    // atribuveis entre si.  Por isso cada bloco de teste  colocado
    // entre chavetas:

    {
	ListaDeTelefonema::Iterador i = lista.primeiro();
	assert(i == lista.primeiro());
	assert(i.item() == Telefonema("1", 1));
	++i;
	assert(i.item() == Telefonema("2", 12));
	ListaDeTelefonema::Iterador j1 = ++i;
	assert(j1 == i);
	assert(i.item() == Telefonema("3", 123));
	ListaDeTelefonema::Iterador j2 = i++;
	assert(j2 == j1);
	assert(i == lista.ultimo());
	assert(i.item() == Telefonema("4", 1234));
	++i;
	assert(i == lista.fim());
    }

    assert(lista.ultimo() != lista.inicio());
    lista.esvazia();
    assert(lista.estaVazia());
    assert(lista.comprimento() == 0);
    assert(lista.primeiro() == lista.fim());
    assert(lista.ultimo() == lista.inicio());

    lista.poeNaFrente(Telefonema("2", 12));
    lista.poeAtras(Telefonema("3", 123));
    lista.poeNaFrente(Telefonema("1", 1));
    lista.poeAtras(Telefonema("4", 1234));

    {
	ListaDeTelefonema::Iterador i = lista.ultimo();
	assert(i == lista.ultimo());
	++i;
	assert(i == lista.fim());
	--i;
	assert(i.item() == Telefonema("4", 1234));
	ListaDeTelefonema::Iterador j1 = --i;
	assert(j1 == i);
	assert(i.item() == Telefonema("3", 123));
	ListaDeTelefonema::Iterador j2 = i--;
	assert(j2 == j1);
	assert(i.item() == Telefonema("2", 12));
	--i;
	assert(i == lista.primeiro());
	assert(i.item() == Telefonema("1", 1));
	--i;
	assert(i == lista.inicio());
	++i;
	assert(i == lista.primeiro());
    }

    {
	ListaDeTelefonema::Iterador i = lista.primeiro();
	++i;
	lista.insereAntes(i, Telefonema("10", 10));
	assert(lista.comprimento() == 5);
	assert(i.item() == Telefonema("2", 12));
	--i;
	--i;
	assert(i == lista.primeiro());
	assert(i.item() == Telefonema("1", 1));
	++i;
	assert(i.item() == Telefonema("10", 10));
	++i;
	assert(i.item() == Telefonema("2", 12));
	++i;
	assert(i.item() == Telefonema("3", 123));
	++i;
	assert(i == lista.ultimo());
	assert(i.item() == Telefonema("4", 1234));
	++i;
	assert(i == lista.fim());
    }

    {
	ListaDeTelefonema::Iterador i = lista.primeiro();
	++i;
	++i;
	lista.remove(i);
	assert(lista.comprimento() == 4);
	assert(i.item() == Telefonema("3", 123));
    }

    {
	ListaDeTelefonema::Iterador i = lista.primeiro();
	assert(i == lista.primeiro());
	assert(i.item() == Telefonema("1", 1));
	++i;
	assert(i.item() == Telefonema("10", 10));
	++i;
	assert(i.item() == Telefonema("3", 123));
	++i;
	assert(i == lista.ultimo());
	assert(i.item() == Telefonema("4", 1234));
	++i;
	assert(i == lista.fim());
    }

    lista.tiraDaFrente();
    lista.tiraDeTras();
    assert(lista.comprimento() == 2);
    assert(lista.frente() == Telefonema("10", 10));
    assert(lista.tras() == Telefonema("3", 123));

    {
	ListaDeTelefonema::Iterador i = lista.primeiro();
	assert(i.item() == Telefonema("10", 10));
	++i;
	assert(i.item() == Telefonema("3", 123));
	++i;
	assert(i == lista.fim());
    }

    assert(not lista.estaVazia());

    lista.tiraDaFrente();
    lista.tiraDeTras();
    assert(lista.comprimento() == 0);
    assert(lista.estaVazia());
}

#endif // TESTE
