#include <cassert>

#include <Utilitarios/ignoradores.H>

inline Telefonema::Telefonema(std::string const& numero, int const duracao) 
    : numero_(numero), duracao_(duracao)
{
    assert(0 <= duracao);

    assert(cumpreInvariante());
}

inline Telefonema::Telefonema(std::istream& canal_de_entrada)
{
    assert(canal_de_entrada.good());

    std::getline(canal_de_entrada, numero_);
    canal_de_entrada >> duracao_ >> Utilitarios::il;    

    // Em rigor deveria verificar se a leitura tem sucesso e, no caso de no
    // ter, deveria lanar uma excepo...  Assunto a tratar mais tarde.
    if(canal_de_entrada.fail())
	/* Lanar excepo... */;

    assert(cumpreInvariante());
}

inline std::string const& Telefonema::numero() const
{
    assert(cumpreInvariante());

    return numero_;
}

inline int Telefonema::duracao() const
{
    assert(cumpreInvariante());

    return duracao_;
}

inline void Telefonema::guardaEm(std::ostream& canal_de_saida) const
{
    assert(cumpreInvariante());
    assert(canal_de_saida.good());

    canal_de_saida << numero_ << std::endl 
		   << duracao_ << std::endl;    
}

inline bool Telefonema::cumpreInvariante() const
{
    return 0 <= duracao_;
}

inline bool operator==(Telefonema const& um_telefonema, 
		       Telefonema const& outro_telefonema)
{
    return um_telefonema.numero() == outro_telefonema.numero() and
	um_telefonema.duracao() == outro_telefonema.duracao();
}

inline bool operator!=(Telefonema const& um_telefonema, 
		       Telefonema const& outro_telefonema)
{
    return not (um_telefonema == outro_telefonema);
}

inline std::ostream& operator<<(std::ostream& canal_de_saida, 
				Telefonema const& telefonema)
{
    assert(canal_de_saida.good());

    return canal_de_saida << telefonema.numero() << ' ' 
			  << telefonema.duracao();    
}
