#include "lista_de_double.H"

/* Aqui podia-se resolver o problema de vrias formas.	Com
   iteradores, por exemplo.  Ou chamando tiraDaFrente() at a lista
   estar vazia.	 A soluo escolhida  da baixo nvel, e  tambm mais
   eficiente...	 Mas  a que exige maiores alteraes se se mudar a
   implementao da lista... */
void ListaDeDouble::esvazia()
{
    assert(cumpreInvariante());

    numero_de_itens = 0;

    // Destruir elos dinmicos:
    for(Elo* elo = elo_inicial->seguinte; elo != elo_final; ) {
	Elo* seguinte = elo->seguinte;
	delete elo;
	elo = seguinte;
    }

    // A cadeia duplamente ligada tem de ficar vazia:
    elo_inicial->seguinte = elo_final;
    elo_final->anterior = elo_inicial;

    assert(cumpreInvariante());
}

ListaDeDouble& ListaDeDouble::operator+=(ListaDeDouble const& outra_lista)
{
    assert(cumpreInvariante());
    assert(outra_lista.cumpreInvariante());

    if(this != &outra_lista)
	for(Elo* elo = outra_lista.elo_inicial->seguinte;
	    elo != outra_lista.elo_final; elo = elo->seguinte)
	    poeAtras(elo->item);
    else {
	Elo* const ultimo_elo = outra_lista.elo_final->anterior;
	for(Elo* elo = outra_lista.elo_inicial->seguinte;
	    elo != ultimo_elo->seguinte; elo = elo->seguinte)
	    poeAtras(elo->item);
    }

    assert(cumpreInvariante());

    return *this;
}

ListaDeDouble::IteradorConstante ListaDeDouble::
primeiraOcorrenciaDe(Item const& item) const
{
    IteradorConstante i = primeiro();
    while(i != fim() && *i != item)
	++i;

    return i;
}

ListaDeDouble::IteradorConstante
ListaDeDouble::ultimaOcorrenciaDe(Item const& item) const
{
    IteradorConstante i = ultimo();
    while(i != inicio() && *i != item)
	--i;

    return i;
}

ListaDeDouble::Iterador ListaDeDouble::primeiraOcorrenciaDe(Item const& item)
{
    Iterador i = primeiro();
    while(i != fim() and *i != item)
	++i;

    return i;
}

ListaDeDouble::Iterador ListaDeDouble::ultimaOcorrenciaDe(Item const& item)
{
    Iterador i = ultimo();
    while(i != inicio() and *i != item)
	--i;

    return i;
}

std::ostream& operator<<(std::ostream& saida, ListaDeDouble const& lista)
{
    saida << '(';
    for(ListaDeDouble::IteradorConstante i = lista.primeiro();
	i != lista.fim(); ++i) {
	saida << *i;
	if(i != lista.ultimo())
	    saida << ",";
    }
    return saida << ')';
}


#ifdef TESTE

/* Tal como esto implementadas as listas, este teste tem obrigao de falhar!
   Ser que consegue descobrir porqu?	*/

#include <iostream>
#include <fstream>

using namespace std;

/** Teste de unidade do TAD ListaDeDoubles.  Verifica o bom
    funcionamento de todas as operaes sem excepo! */
int main()
{
    ListaDeDouble lista;

    assert(lista.comprimento() == 0);

    lista.poeNaFrente(2.12);
    lista.poeAtras(3.123);
    lista.poeNaFrente(1.1);
    lista.poeAtras(4.1234);

    assert(lista.comprimento() == 4);

    assert(lista.frente() == 1.1);
    assert(lista.tras() == 4.1234);

    // No se pode reaproveitar os iteradores, pois no so
    // atribuveis entre si.  Por isso cada bloco de teste  colocado
    // entre chavetas:

    {
	ListaDeDouble::Iterador i = lista.primeiro();
	assert(i == lista.primeiro());
	assert(*i == 1.1);
	++i;
	assert(*i == 2.12);
	ListaDeDouble::Iterador j1 = ++i;
	assert(j1 == i);
	assert(*i == 3.123);
	ListaDeDouble::Iterador j2 = i++;
	assert(j2 == j1);
	assert(i == lista.ultimo());
	assert(*i == 4.1234);
	++i;
	assert(i == lista.fim());
    }

    assert(lista.ultimo() != lista.inicio());
    lista.esvazia();
    assert(lista.estaVazia());
    assert(lista.comprimento() == 0);
    assert(lista.primeiro() == lista.fim());
    assert(lista.ultimo() == lista.inicio());

    lista.poeNaFrente(2.12);
    lista.poeAtras(3.123);
    lista.poeNaFrente(1.1);
    lista.poeAtras(4.1234);

    {
	ListaDeDouble::Iterador i = lista.ultimo();
	assert(i == lista.ultimo());
	++i;
	assert(i == lista.fim());
	--i;
	assert(*i == 4.1234);
	ListaDeDouble::Iterador j1 = --i;
	assert(j1 == i);
	assert(*i == 3.123);
	ListaDeDouble::Iterador j2 = i--;
	assert(j2 == j1);
	assert(*i == 2.12);
	--i;
	assert(i == lista.primeiro());
	assert(*i == 1.1);
	--i;
	assert(i == lista.inicio());
	++i;
	assert(i == lista.primeiro());
    }

    {
	ListaDeDouble::Iterador i = lista.primeiro();
	++i;
	lista.insereAntes(i, 10.10);
	assert(lista.comprimento() == 5);
	assert(*i == 2.12);
	--i;
	--i;
	assert(i == lista.primeiro());
	assert(*i == 1.1);
	++i;
	assert(*i == 10.10);
	++i;
	assert(*i == 2.12);
	++i;
	assert(*i == 3.123);
	++i;
	assert(i == lista.ultimo());
	assert(*i == 4.1234);
	++i;
	assert(i == lista.fim());
    }

    {
	ListaDeDouble::Iterador i = lista.primeiro();
	++i;
	++i;
	lista.remove(i);
	assert(lista.comprimento() == 4);
	assert(*i == 3.123);
    }

    {
	ListaDeDouble::Iterador i = lista.primeiro();
	assert(i == lista.primeiro());
	assert(*i == 1.1);
	++i;
	assert(*i == 10.10);
	++i;
	assert(*i == 3.123);
	++i;
	assert(i == lista.ultimo());
	assert(*i == 4.1234);
	++i;
	assert(i == lista.fim());
    }

    lista.tiraDaFrente();
    lista.tiraDeTras();
    assert(lista.comprimento() == 2);
    assert(lista.frente() == 10.10);
    assert(lista.tras() == 3.123);

    {
	ListaDeDouble::Iterador i = lista.primeiro();
	assert(*i == 10.10);
	++i;
	assert(*i == 3.123);
	++i;
	assert(i == lista.fim());
    }

    assert(not lista.estaVazia());

    lista.tiraDaFrente();
    lista.tiraDeTras();
    assert(lista.comprimento() == 0);
    assert(lista.estaVazia());

    lista.poeNaFrente(2.12);
    lista.poeAtras(3.123);
    lista.poeNaFrente(1.1);
    lista.poeAtras(4.1234);

    lista.insereAntes(lista.primeiraOcorrenciaDe(3.123),
		      21.121);

    assert(lista.comprimento() == 5);

    {
	ListaDeDouble::Iterador i = lista.ultimo();
	-- --i;
	assert(*i == 21.121);

	++ ++i;

	i = lista.primeiraOcorrenciaDe(21.121);
	lista.insereAntes(i, 20.120);

	assert(lista.comprimento() == 6);

	assert(*i == 21.121);

	--i;

	assert(*i == 20.120);
    }

    ListaDeDouble nova_lista;
    nova_lista += lista;
    // Devia ser ListaDeDouble nova_lista = lista;

    {
	ListaDeDouble::Iterador i = lista.primeiro();
	ListaDeDouble::Iterador j = nova_lista.primeiro();
	
	while(i != lista.fim() and j != nova_lista.fim()) {
	    assert(*i == *j);
	    ++i;
	    ++j;
	}

	assert(i == lista.fim() and j == nova_lista.fim());
    }

    nova_lista.tiraDaFrente();

    assert(lista.frente() == 1.1);

    lista.esvazia();
    lista += nova_lista;
    // Deveria ser lista = nova_lista;

    {
	ListaDeDouble::Iterador i = lista.primeiro();
	ListaDeDouble::Iterador j = nova_lista.primeiro();
	
	while(i != lista.fim() and j != nova_lista.fim()) {
	    assert(*i == *j);
	    ++i;
	    ++j;
	}

	assert(i == lista.fim() and j == nova_lista.fim());
    }

    ListaDeDouble outra_lista;
    outra_lista += nova_lista;
    // Deveria ser ListaDeDouble outra_lista = nova_lista;

    outra_lista += nova_lista;

    {
	ListaDeDouble::Iterador i = nova_lista.primeiro();
	ListaDeDouble::Iterador j = outra_lista.primeiro();
	
	while(i != nova_lista.fim() and j != outra_lista.fim()) {
	    assert(*i == *j);
	    ++i;
	    ++j;
	}

	assert(i == nova_lista.fim() and j != outra_lista.fim());

	i = nova_lista.primeiro();
	while(i != nova_lista.fim() and j != outra_lista.fim()) {
	    assert(*i == *j);
	    ++i;
	    ++j;
	}

	assert(i == nova_lista.fim() and j == outra_lista.fim());
    }

    ListaDeDouble ainda_outra_lista;
    ainda_outra_lista.transfereDe(outra_lista);

    assert(outra_lista.estaVazia());

    {
	ListaDeDouble::Iterador i = lista.primeiro();
	ListaDeDouble::Iterador j = ainda_outra_lista.primeiro();
	
	while(i != lista.fim() and j != ainda_outra_lista.fim()) {
	    assert(*i == *j);
	    ++i;
	    ++j;
	}

	assert(i == lista.fim() and j != ainda_outra_lista.fim());

	i = lista.primeiro();

	while(i != lista.fim() and j != ainda_outra_lista.fim()) {
	    assert(*i == *j);
	    ++i;
	    ++j;
	}

	assert(i == lista.fim() and j == ainda_outra_lista.fim());
    }

    lista.esvazia();
    lista.poeAtras(1.1);
    lista += lista;
    lista.transfereDe(lista);

    assert(lista.comprimento() == 2);
    assert(lista.frente() == 1.1);
    assert(lista.tras() == 1.1);

    ListaDeDouble lista_recomecada;

    lista_recomecada.poeNaFrente(2.12);
    lista_recomecada.poeAtras(3.123);
    lista_recomecada.poeNaFrente(1.1);
    lista_recomecada.poeAtras(4.1234);

    ListaDeDouble const lista_constante = lista_recomecada;

    assert(not lista_constante.estaVazia());
    assert(lista_constante.frente() == 1.1);
    assert(lista_constante.tras() == 4.1234);

    {
	ListaDeDouble::IteradorConstante i = lista_constante.primeiro();
	ListaDeDouble::Iterador j = lista_recomecada.primeiro();
	
	while(i != lista_constante.fim() and j != lista_recomecada.fim()) {
	    assert(*i == *j);
	    ++i;
	    ++j;
	}
	
	assert(i == lista_constante.fim() and j == lista_recomecada.fim());
    }

    {
	ListaDeDouble::IteradorConstante i = lista_constante.primeiro();
	ListaDeDouble::Iterador j = lista_recomecada.primeiro();
	
	while(i != lista_constante.fim() and j != lista_recomecada.fim()) {
	    assert(*i == *j);
	    i++;
	    ++j;
	}
	
	assert(i == lista_constante.fim() and j == lista_recomecada.fim());
    }

    ListaDeDouble::Iterador i = lista_recomecada.primeiro();
    ListaDeDouble::IteradorConstante j = lista_recomecada.primeiro();

    assert(i == j);

    lista_recomecada.insereAntes(j, 5.12345);
    --i;
    assert(*i == 5.12345);
    assert(*j == 1.1);

    lista_recomecada.remove(j);
    ++i;
    assert(*i == 2.12);
    assert(*j == 2.12);

    ListaDeDouble::IteradorConstante const ic = i;
    ListaDeDouble::Iterador const jc = ++i;
    lista_recomecada.tiraDaFrente();
    assert(lista_recomecada.comprimento() == 3);

    lista_recomecada.remove(ic);
    lista_recomecada.remove(jc);

    assert(lista_recomecada.comprimento() == 1);
    assert(lista_recomecada.frente() == 4.1234);
    assert(lista_recomecada.tras() == 4.1234);
}

#endif // TESTE
