#ifndef FILME_H
#define FILME_H

#include <iosfwd>
#include <string>

/** Representa filmes. 
    @invariant 0 <= duracao_. */
class Filme {
public:
    /** Constri novo filme com nome, realizador e durao dados.
	@pre 0 <= duracao.
	@post nome() = nome e realizador() = realizador e duracao() =
	duracao. */
    Filme(std::string const& nome, std::string const& realizador,
	  int duracao);

    /** Constri novo filme com informao extrada do canal de
	entrada. 
	@pre entrada.
	@post *this tem informao extrada do canal de entrada. */
    explicit Filme(std::istream& entrada);
    
    /** Devolve o nome do filme.
	@pre V.
	@post nome = nome do filme. */
    std::string const& nome() const;

    /** Devolve o realizador do filme.
	@pre V.
	@post realizador = realizador do filme. */
    std::string const& realizador() const;

    /** Devolve a durao do filme.
	@pre V.
	@post duracao = durao do filme. */
    int duracao() const;
    
    /** Mostra informao sobre o filme no canal dado num formato
	agradvel  vista.
	@pre V.
	@post saida contm a informao sobre o filme. */
    void mostraEm(std::ostream& saida) const;

    /** Guarda informao sobre o filme no canal dado num formato
	apropriado a futuros carregamentos.
	@pre saida.
	@post saida contm a informao sobre o filme. */
    // void guardaEm(std::ostream& saida) const;

    /** Le informao sobre o filme do canal dado assumindo que este
	est ligado a um ser humano (e.g., leitura do teclado).
	@pre V.
	@post *this contm a informao sobre o filme lida do canal de
	entrada. */
    // void leDe(std::istream& entrada);

    /** Carrega informao sobre o filme do canal dado assumindo que este
	est ligado no formato usado pela operao carrega().
	@pre entrada.
	@post *this contm a informao sobre o filme carregada do canal de
	entrada. */
    void carregaDe(std::istream& entrada);
    
private:
    std::string nome_;
    std::string realizador_;
    int duracao_;

    /** Indica se a condio invariante da classe se verifica.
	@pre V.
	@post cumpreInvariante = 0 <= duracao_. */
    bool cumpreInvariante() const;
};

#include "filme_impl.H"

#endif // FILME_H
