#include <iostream>
#include <cassert>

inline FilmeEstrangeiro::FilmeEstrangeiro(std::string const& nome, 
                                          std::string const& realizador,
                                          int duracao, 
                                          std::string const& pais,
					  std::string const& lingua)
    : Filme(nome, realizador, duracao), lingua_(lingua), pais_(pais) 
{
    assert(0 <= duracao);

    assert(cumpreInvariante());
}

inline FilmeEstrangeiro::FilmeEstrangeiro(std::istream& entrada) 
    : Filme(entrada) 
{
    assert(entrada);

    std::getline(entrada, pais_ );
    std::getline(entrada, lingua_);

    if(not entrada)
	throw Erros::ErroAoCarregar("FilmeEstrangeiro");

    assert(cumpreInvariante());
}

inline std::string const& FilmeEstrangeiro::pais() const 
{
    assert(cumpreInvariante());

    return pais_;
}

inline std::string const& FilmeEstrangeiro::lingua() const 
{
    assert(cumpreInvariante());

    return lingua_;
}

inline void FilmeEstrangeiro::carregaDe(std::istream& entrada)
{
    assert(cumpreInvariante());

    *this = FilmeEstrangeiro(entrada);

    assert(cumpreInvariante());
}

inline void FilmeEstrangeiro::mostraEm(std::ostream& saida) const 
{
    assert(cumpreInvariante());

    Filme::mostraEm(saida);
    saida << "Pas:\t\t" << pais() << std::endl
          << "Lngua:\t\t" << lingua() << std::endl;
}

inline bool FilmeEstrangeiro::cumpreInvariante() const
{
    return true;
}

inline EdicaoDoRealizador::EdicaoDoRealizador(std::string const& nome, 
                                              std::string const& realizador,
                                              int duracao, 
                                              std::string const& alteracoes) 
    : Filme(nome, realizador, duracao), alteracoes_(alteracoes) 
{
    assert(0 <= duracao);

    assert(cumpreInvariante());
}

inline EdicaoDoRealizador::EdicaoDoRealizador(std::istream& entrada) 
    : Filme(entrada) 
{
    assert(entrada);

    std::getline(entrada, alteracoes_ );

    if(not entrada)
	throw Erros::ErroAoCarregar("FilmeEstrangeiro");

    assert(cumpreInvariante());
}

inline std::string EdicaoDoRealizador::alteracoes() const 
{
    assert(cumpreInvariante());

    return alteracoes_;
}

inline void EdicaoDoRealizador::carregaDe(std::istream& entrada) 
{
    assert(cumpreInvariante());

    *this = EdicaoDoRealizador(entrada);

    assert(cumpreInvariante());
}

inline void EdicaoDoRealizador::mostraEm(std::ostream& saida) const 
{
    assert(cumpreInvariante());

    Filme::mostraEm(saida);
    saida << "Alteraes:\t" << alteracoes() << std::endl;
}

inline bool EdicaoDoRealizador::cumpreInvariante() const
{
    return true;
}

