#include <string>
#include <iostream>

int const nota_minima_de_aprovacao = 10;
int const nota_maxima = 20;

class Aluno {
  public:
    Aluno(std::string const& nome, int const numero, 
	  int const nota = nota_maxima);
  
    std::string const& nome() const;
    int numero() const;
    int nota() const;

    void mudaNomePara(std::string const& novo_nome);
    void mudaNumeroPara(int novo_numero);
    void mudaNotaPara(int nova_nota);

private:
    std::string nome_;
    int numero_;
    int nota_;

    bool cumpreInvariante() const;
};

std::ostream& operator<<(std::ostream& saida, Aluno const& aluno);
std::istream& operator>>(std::istream& entrada, Aluno& aluno);

bool ePositiva(int const nota);

#include "aluno_impl.H"
