#include <cassert>

inline bool ePositiva(int const nota)
{
    return nota_minima_de_aprovacao <= nota;
}

inline Aluno::Aluno(std::string const& nome, int const numero,
                    int const nota)
    : nome_(nome), numero_(numero), nota_(nota) 
{
    assert(0 <= nota and nota <= nota_maxima and 0 <= numero);
    
    assert(cumpreInvariante());
}

inline std::string const& Aluno::nome() const 
{
    assert(cumpreInvariante());
    
    return nome_;
}

inline int Aluno::numero() const 
{
    assert(cumpreInvariante());
    
    return numero_;
}

inline int Aluno::nota() const 
{
    assert(cumpreInvariante());
    
    return nota_;
}

inline void Aluno::mudaNomePara(std::string const& novo_nome) 
{
    assert(cumpreInvariante());
    
    nome_ = novo_nome;

    assert(cumpreInvariante());
}

inline void Aluno::mudaNumeroPara(int const novo_numero) 
{
    assert(cumpreInvariante());
    assert(0 <= novo_numero);

    numero_ = novo_numero;

    assert(cumpreInvariante());
}

inline void Aluno::mudaNotaPara(int const nova_nota) 
{
    assert(cumpreInvariante());
    assert(0 <= nova_nota and nova_nota <= nota_maxima);

    nota_ = nova_nota;

    assert(cumpreInvariante());
}

inline bool Aluno::cumpreInvariante() const
{
    return 0 <= nota_ and nota_ <= nota_maxima and 0 <= numero_;
}

inline std::ostream& operator<<(std::ostream& saida, Aluno const& aluno) 
{
    return saida << aluno.nome() << ' ' << aluno.numero() << ' '
                 << aluno.nota();
}
