#include "iterador_menor.H"

IteradorMenor::IteradorMenor(ListaDeDouble& lista)
    : primeiro(lista.primeiro()), fim(lista.fim()), iterador(lista.primeiro())
{
    for(ListaDeDouble::Iterador i = primeiro; i != fim; ++i)
	if(i.item() < iterador.item())
	    while(iterador != i)
		++iterador;

    assert(cumpreInvariante());
}

IteradorMenor::IteradorMenor(ListaDeDouble::Iterador const& primeiro,
			     ListaDeDouble::Iterador const& fim)
: primeiro(primeiro), fim(fim), iterador(primeiro)
{
    for(ListaDeDouble::Iterador i = primeiro; i != fim; ++i)
	if(i.item() < iterador.item())
	    // iterador = i;
	    while(iterador != i)
		++iterador;

    assert(cumpreInvariante());
}

IteradorMenor& IteradorMenor::operator++()
{
    assert(cumpreInvariante());
    assert(iterador != fim);

    ListaDeDouble::Iterador i = iterador++; 
    while(iterador != fim and iterador.item() != i.item())
	++iterador;

    assert(cumpreInvariante());

    return *this;
}

#ifdef TESTE

#include "lista_de_double.H"

#include <iostream>

using namespace std;

int main()
{
    ListaDeDouble lista;

    lista.poeAtras(4.0);
    lista.poeAtras(2.0);
    lista.poeAtras(1.0);
    lista.poeAtras(6.0);
    lista.poeAtras(5.0);
    lista.poeAtras(1.0);
    lista.poeAtras(3.0);
    lista.poeAtras(1.0);

    IteradorMenor i(lista);

    assert(i.item() == 1.0);

    ++i;

    assert(i.item() == 1.0);

    ++i;

    assert(i.item() == 1.0);

    ++i;

    assert(i == lista.fim());
}

#endif // TESTE
