#ifndef ITERADOR_MENOR_H
#define ITERADOR_MENOR_H

#include "lista_de_double.H"

/** Representa iteradores que percorrem os menores itens de uma sequncia de
    itens de uma lista de double.
    @invariant Iteradores referem-se  mesma lista e 
               primeiro <= iterador <= fim. */
class IteradorMenor {
  public:
    typedef ListaDeDouble::Item Item;

    /** Contri novo iterador referenciando o primeiro dos menores
	itens da lista. 
	@pre V.
	@post *this referencia o primeiro dos menores itens de lista. */
    IteradorMenor(ListaDeDouble& lista);

    /** Contri novo iterador referenciando o primeiro dos menores
	itens de uma sequncia de itens de uma lista. 
	@pre primeiro <= fim.
	@post *this referencia o primeiro dos menores itens a sequncia de
	      itens entre primeiro e fim (exclusive). */
    IteradorMenor(ListaDeDouble::Iterador const& primeiro,
		  ListaDeDouble::Iterador const& fim);

    /** Igualdade entre iteradores.
	@pre *this e outro_iterador referem-se  mesma sequncia de itens.
	@post operator== = *this e outro_iterador referem -se ao mesmo item. */
    bool operator==(IteradorMenor const& outro_iterador) const;

    /** Igualdade entre iterador menor e iterador "normal".
	@pre *this e outro_iterador referem-se  mesma sequncia de itens.
	@post operator== = *this e outro_iterador referem-se ao mesmo item. */
    bool operator==(ListaDeDouble::Iterador const& outro_iterador) const;

    /** Diferena entre iteradores.
	@pre *this e outro_iterador referem-se  mesma sequncia de itens.
	@post operator!= = *this e outro_iterador no se referem ao mesmo 
	      item. */
    bool operator!=(IteradorMenor const& outro_iterador) const;

    /** Diferena entre iterador menor e iterador "normal".
	@pre *this e outro_iterador referem-se  mesma sequncia de itens.
	@post operator!= = *this e outro_iterador no se referem ao mesmo 
	      item. */
    bool operator!=(ListaDeDouble::Iterador const& outro_iterador) const;

    /** Devolve o item referenciado pelo iterador.
	@pre *this != fim da sequncia.
	@post item = item referenciado pelo iterador. */
    Item& item() const;

    /** Incrementa o iterador, devolvendo-o.
	@pre *this = i e *this != fim da sequncia.
	@post *this referencia o menor item da sequncia aps i e 
	      operator++ = *this. */
    IteradorMenor& operator++();

  private:
    ListaDeDouble::Iterador primeiro;
    ListaDeDouble::Iterador fim;
    ListaDeDouble::Iterador iterador;

    /** Indica se a condio invariante  verdadeira.
	@pre V.
	@post . */
    bool cumpreInvariante() const;
};

#include "iterador_menor_impl.H"

#endif // ITERADOR_MENOR_H
