#include "iterador_ordenado.H"

IteradorOrdenado::IteradorOrdenado(ListaDeDouble& lista)
    : primeiro(lista.primeiro()), fim(lista.fim()), iterador(lista.primeiro())
{
    for(ListaDeDouble::Iterador i = primeiro; i != fim; ++i)
	if(i.item() < iterador.item())
	    while(iterador != i)
		++iterador;

    assert(cumpreInvariante());
}

IteradorOrdenado::IteradorOrdenado(ListaDeDouble::Iterador const& primeiro,
				    ListaDeDouble::Iterador const& fim)
: primeiro(primeiro), fim(fim), iterador(primeiro)
{
    for(ListaDeDouble::Iterador i = primeiro; i != fim; ++i)
	if(i.item() < iterador.item())
	    while(iterador != i)
		++iterador;

    assert(cumpreInvariante());
}

IteradorOrdenado& IteradorOrdenado::operator++()
{
    assert(cumpreInvariante());
    assert(iterador != fim);

    ListaDeDouble::Iterador referencia = iterador;

    for(++iterador; iterador != fim; ++iterador)
	if(referencia.item() == iterador.item())
	    return *this;

    while(iterador != primeiro)
	--iterador;

    while(iterador != fim and iterador.item() <= referencia.item())
	++iterador;

    for(ListaDeDouble::Iterador i = iterador; i != fim; ++i)
	if(referencia.item() < i.item() and i.item() < iterador.item())
	    while(iterador != i)
		++iterador;

    assert(cumpreInvariante());

    return *this;
}

#ifdef TESTE

#include "lista_de_double.H"

#include <cstdlib>

using namespace std;

int main()
{
    srand(100);
    int const numero_de_testes = 100;

    for(int i = 0; i != numero_de_testes; ++i) {
	ListaDeDouble lista;
	ListaDeDouble lista_ordenada;

	for(int j = 0; j != i; ++j) {
	    lista.poeAtras(double(j));
	    ListaDeDouble::Iterador i = lista_ordenada.primeiro();
	    while(i != lista_ordenada.fim() and i.item() < double(j))
		++i;
	    lista_ordenada.insereAntes(i, double(j));
	}

	ListaDeDouble::Iterador i = lista_ordenada.primeiro();
	IteradorOrdenado j(lista);
	while(i != lista_ordenada.fim() and j != lista.fim()) {
	    assert(i.item() == j.item());
	    ++i;
	    ++j;
	}

	assert(i == lista_ordenada.fim() and j == lista.fim());
    }
}

#endif // TESTE
