#ifndef ITERADOR_ORDENADO_H
#define ITERADOR_ORDENADO_H

#include "lista_de_double.H"

/** Representa iteradores que percorrem os itens de uma sequncia de
    itens de uma lista de double por ordem crescente de valor.  Itens com o 
    mesmo valor so percorridos pela ordem original na sequncia.
    @invariant Iteradores referem-se  mesma lista e 
               primeiro <= iterador <= fim. */
class IteradorOrdenado {
  public:
    typedef ListaDeDouble::Item Item;

    /** Contri novo iterador referenciando o primeiro dos menores
	itens da lista. 
	@pre V.
	@post *this referencia o primeiro dos menores itens de lista. */
    IteradorOrdenado(ListaDeDouble& lista);

    /** Contri novo iterador referenciando o primeiro dos menores
	itens de uma sequncia de itens de uma lista. 
	@pre primeiro <= fim.
	@post *this referencia o primeiro dos menores itens a sequncia de
	      itens entre primeiro e fim (exclusive). */
    IteradorOrdenado(ListaDeDouble::Iterador const& primeiro,
		  ListaDeDouble::Iterador const& fim);

    /** Igualdade entre iteradores.
	@pre *this e outro_iterador referem-se  mesma sequncia de itens.
	@post operator== = *this e outro_iterador referem -se ao mesmo item. */
    bool operator==(IteradorOrdenado const& outro_iterador) const;

    /** Igualdade entre iterador menor e iterador "normal".
	@pre *this e outro_iterador referem-se  mesma sequncia de itens.
	@post operator== = *this e outro_iterador referem-se ao mesmo item. */
    bool operator==(ListaDeDouble::Iterador const& outro_iterador) const;

    /** Diferena entre iteradores.
	@pre *this e outro_iterador referem-se  mesma sequncia de itens.
	@post operator!= = *this e outro_iterador no se referem ao mesmo 
	      item. */
    bool operator!=(IteradorOrdenado const& outro_iterador) const;

    /** Diferena entre iterador menor e iterador "normal".
	@pre *this e outro_iterador referem-se  mesma sequncia de itens.
	@post operator!= = *this e outro_iterador no se referem ao mesmo 
	      item. */
    bool operator!=(ListaDeDouble::Iterador const& outro_iterador) const;

    /** Devolve o item referenciado pelo iterador.
	@pre *this != fim da sequncia.
	@post item = item referenciado pelo iterador. */
    Item& item() const;

    /** Incrementa o iterador, devolvendo-o.
	@pre *this = i e *this != fim da sequncia.
	@post *this referencia item da sequncia aps i.item(), i.e., o item 
	      com o mesmo valor mas  frente na sequncia original ou o 
	      primeiro dos menores itens com valor superior a i.item() e 
              operator++ = *this. */
    IteradorOrdenado& operator++();

  private:
    ListaDeDouble::Iterador primeiro;
    ListaDeDouble::Iterador fim;
    ListaDeDouble::Iterador iterador;

    /** Indica se a condio invariante  verdadeira.
	@pre V.
	@post . */
    bool cumpreInvariante() const;
};

#include "iterador_ordenado_impl.H"

#endif // ITERADOR_ORDENADO_H
