#include "lista_de_double.H"

void ListaDeDouble::limpa()
{
    numero_de_itens = 0;
    primeiro_elo_livre = 0;

    // Criar cadeia duplamente ligada de elos ocupados vazia (s com guardas):
    elos[elo_inicial].seguinte = elo_final;
    elos[elo_final].anterior = elo_inicial;

    /* Criar cadeia simplesmente ligada de elos livres com todos os elos da
       matriz (excepto guardas): */
    for(int i = 0; i != numero_maximo_de_itens - 1; ++i)
	elos[i].seguinte = i + 1;
    /* O elo numero_maximo_de_itens - 1 no precisa de ter seguinte
       vlido!	Porqu? */
}

std::ostream& operator<<(std::ostream& saida, ListaDeDouble& lista)
{
    saida << '(';
    for(ListaDeDouble::Iterador i = lista.primeiro(); i != lista.fim();
	++i)
    {
	saida << i.item();
	if(i != lista.ultimo())
	    saida << ",";
    }
    return saida << ')';
}


#ifdef TESTE

#include <iostream>
#include <fstream>

using namespace std;

/** Teste de unidade do TAD ListaDeDoubles.  Verifica o bom
    funcionamento de todas as operaes sem excepo! */
int main()
{
    ListaDeDouble lista;

    assert(lista.comprimento() == 0);

    lista.poeNaFrente(2.12);
    lista.poeAtras(3.123);
    lista.poeNaFrente(1.1);
    lista.poeAtras(4.1234);

    assert(lista.comprimento() == 4);

    assert(lista.frente() == 1.1);
    assert(lista.tras() == 4.1234);

    // No se pode reaproveitar os iteradores, pois no so
    // atribuveis entre si.  Por isso cada bloco de teste  colocado
    // entre chavetas:

    {
	ListaDeDouble::Iterador i = lista.primeiro();
	assert(i == lista.primeiro());
	assert(i.item() == 1.1);
	++i;
	assert(i.item() == 2.12);
	ListaDeDouble::Iterador j1 = ++i;
	assert(j1 == i);
	assert(i.item() == 3.123);
	ListaDeDouble::Iterador j2 = i++;
	assert(j2 == j1);
	assert(i == lista.ultimo());
	assert(i.item() == 4.1234);
	++i;
	assert(i == lista.fim());
    }

    assert(lista.ultimo() != lista.inicio());
    lista.esvazia();
    assert(lista.estaVazia());
    assert(lista.comprimento() == 0);
    assert(lista.primeiro() == lista.fim());
    assert(lista.ultimo() == lista.inicio());

    lista.poeNaFrente(2.12);
    lista.poeAtras(3.123);
    lista.poeNaFrente(1.1);
    lista.poeAtras(4.1234);

    {
	ListaDeDouble::Iterador i = lista.ultimo();
	assert(i == lista.ultimo());
	++i;
	assert(i == lista.fim());
	--i;
	assert(i.item() == 4.1234);
	ListaDeDouble::Iterador j1 = --i;
	assert(j1 == i);
	assert(i.item() == 3.123);
	ListaDeDouble::Iterador j2 = i--;
	assert(j2 == j1);
	assert(i.item() == 2.12);
	--i;
	assert(i == lista.primeiro());
	assert(i.item() == 1.1);
	--i;
	assert(i == lista.inicio());
	++i;
	assert(i == lista.primeiro());
    }

    {
	ListaDeDouble::Iterador i = lista.primeiro();
	++i;
	lista.insereAntes(i, 10.10);
	assert(lista.comprimento() == 5);
	assert(i.item() == 2.12);
	--i;
	--i;
	assert(i == lista.primeiro());
	assert(i.item() == 1.1);
	++i;
	assert(i.item() == 10.10);
	++i;
	assert(i.item() == 2.12);
	++i;
	assert(i.item() == 3.123);
	++i;
	assert(i == lista.ultimo());
	assert(i.item() == 4.1234);
	++i;
	assert(i == lista.fim());
    }

    {
	ListaDeDouble::Iterador i = lista.primeiro();
	++i;
	++i;
	lista.remove(i);
	assert(lista.comprimento() == 4);
	assert(i.item() == 3.123);
    }

    {
	ListaDeDouble::Iterador i = lista.primeiro();
	assert(i == lista.primeiro());
	assert(i.item() == 1.1);
	++i;
	assert(i.item() == 10.10);
	++i;
	assert(i.item() == 3.123);
	++i;
	assert(i == lista.ultimo());
	assert(i.item() == 4.1234);
	++i;
	assert(i == lista.fim());
    }

    lista.tiraDaFrente();
    lista.tiraDeTras();
    assert(lista.comprimento() == 2);
    assert(lista.frente() == 10.10);
    assert(lista.tras() == 3.123);

    {
	ListaDeDouble::Iterador i = lista.primeiro();
	assert(i.item() == 10.10);
	++i;
	assert(i.item() == 3.123);
	++i;
	assert(i == lista.fim());
    }

    assert(not lista.estaVazia());

    lista.tiraDaFrente();
    lista.tiraDeTras();
    assert(lista.comprimento() == 0);
    assert(lista.estaVazia());
}

#endif // TESTE
