#include "lista_de_telefonema.H"

void ListaDeTelefonema::limpa()
{
    numero_de_itens = 0;

    primeiro_elo_livre = elos;

    // Criar cadeia duplamente ligada de elos ocupados vazia (s com guardas):
    elo_inicial->seguinte = elo_final;
    elo_final->anterior = elo_inicial;

    /* Criar cadeia simplesmente ligada de elos livres com todos os elos da
       matriz (excepto guardas): */
    for(Elo* elo = elos; elo != elos + numero_maximo_de_itens - 1; ++elo)
	elo->seguinte = elo + 1;
    // O elo numero_maximo_de_itens - 1 no precisa de ter seguinte vlido!
}

void ListaDeTelefonema::transfereDe(ListaDeTelefonema& outra_lista)
{
    assert(cumpreInvariante() and outra_lista.cumpreInvariante());

    /* O ciclo s funciona se outra_lista e *this no forem a mesma lista!  Se
       forem a mesma lista transferir ... no fazer nada! */
    if(this != &outra_lista) {
	// Haver espao?
	assert(comprimento() + outra_lista.comprimento() <=
	       numero_maximo_de_itens);

	// A implementao escolhida no  a mais eficiente para a Aula 5!  Com
	// variveis dinmicas isto pode ser muito mais simples e eficiente!
	for(; !outra_lista.estaVazia(); outra_lista.tiraDaFrente())
	    poeAtras(outra_lista.frente());
    }

    assert(cumpreInvariante() and outra_lista.cumpreInvariante());
}

ListaDeTelefonema&
ListaDeTelefonema::operator+=(ListaDeTelefonema const& outra_lista)
{
    assert(cumpreInvariante() and outra_lista.cumpreInvariante());
    // Haver espao?
    assert(comprimento() +outra_lista.comprimento() <= numero_maximo_de_itens);

    if(this != &outra_lista)
	/* Este ciclo s funciona se outra_lista e *this no forem a mesma
	   lista! */
	for(Elo* elo = outra_lista.elo_inicial->seguinte;
	    elo != outra_lista.elo_final; elo = elo->seguinte)
	    poeAtras(elo->item);
    else {
	Elo* const ultimo_elo = outra_lista.elo_final->anterior;
	for(Elo* elo = outra_lista.elo_inicial->seguinte;
	    elo != ultimo_elo->seguinte; elo = elo->seguinte)
	    poeAtras(elo->item);
    }

    assert(cumpreInvariante());
    return *this;
}

ListaDeTelefonema::Iterador
ListaDeTelefonema::primeiraOcorrenciaDe(Item const& item)
{
    Iterador i = primeiro();
    while(i != fim() and *i != item)
	++i;
    return i;
}

ListaDeTelefonema::Iterador
ListaDeTelefonema::ultimaOcorrenciaDe(Item const& item)
{
    Iterador i = ultimo();
    while(i != inicio() and *i != item)
	--i;
    return i;
}

std::ostream& operator<<(std::ostream& saida, ListaDeTelefonema& lista)
{
    saida << '(';
    for(ListaDeTelefonema::Iterador i = lista.primeiro(); i != lista.fim();
	++i)
    {
	saida << *i;
	if(i != lista.ultimo())
	    saida << ",";
    }
    return saida << ')';
}


#ifdef TESTE

#include <iostream>
#include <fstream>

using namespace std;

/** Teste de unidade do TAD ListaDeTelefonemas.	 Verifica o bom
    funcionamento de todas as operaes sem excepo! */
int main()
{
    ListaDeTelefonema lista;

    assert(lista.comprimento() == 0);

    lista.poeNaFrente(Telefonema("2", 12));
    lista.poeAtras(Telefonema("3", 123));
    lista.poeNaFrente(Telefonema("1", 1));
    lista.poeAtras(Telefonema("4", 1234));

    assert(lista.comprimento() == 4);

    assert(lista.frente() == Telefonema("1", 1));
    assert(lista.tras() == Telefonema("4", 1234));

    // No se pode reaproveitar os iteradores, pois no so
    // atribuveis entre si.  Por isso cada bloco de teste  colocado
    // entre chavetas:

    {
	ListaDeTelefonema::Iterador i = lista.primeiro();
	assert(i == lista.primeiro());
	assert(*i == Telefonema("1", 1));
	++i;
	assert(*i == Telefonema("2", 12));
	ListaDeTelefonema::Iterador j1 = ++i;
	assert(j1 == i);
	assert(*i == Telefonema("3", 123));
	ListaDeTelefonema::Iterador j2 = i++;
	assert(j2 == j1);
	assert(i == lista.ultimo());
	assert(*i == Telefonema("4", 1234));
	++i;
	assert(i == lista.fim());
    }

    assert(lista.ultimo() != lista.inicio());
    lista.esvazia();
    assert(lista.estaVazia());
    assert(lista.comprimento() == 0);
    assert(lista.primeiro() == lista.fim());
    assert(lista.ultimo() == lista.inicio());

    lista.poeNaFrente(Telefonema("2", 12));
    lista.poeAtras(Telefonema("3", 123));
    lista.poeNaFrente(Telefonema("1", 1));
    lista.poeAtras(Telefonema("4", 1234));

    {
	ListaDeTelefonema::Iterador i = lista.ultimo();
	assert(i == lista.ultimo());
	++i;
	assert(i == lista.fim());
	--i;
	assert(*i == Telefonema("4", 1234));
	ListaDeTelefonema::Iterador j1 = --i;
	assert(j1 == i);
	assert(*i == Telefonema("3", 123));
	ListaDeTelefonema::Iterador j2 = i--;
	assert(j2 == j1);
	assert(*i == Telefonema("2", 12));
	--i;
	assert(i == lista.primeiro());
	assert(*i == Telefonema("1", 1));
	--i;
	assert(i == lista.inicio());
	++i;
	assert(i == lista.primeiro());
    }

    {
	ListaDeTelefonema::Iterador i = lista.primeiro();
	++i;
	lista.insereAntes(i, Telefonema("10", 10));
	assert(lista.comprimento() == 5);
	assert(*i == Telefonema("2", 12));
	--i;
	--i;
	assert(i == lista.primeiro());
	assert(*i == Telefonema("1", 1));
	++i;
	assert(*i == Telefonema("10", 10));
	++i;
	assert(*i == Telefonema("2", 12));
	++i;
	assert(*i == Telefonema("3", 123));
	++i;
	assert(i == lista.ultimo());
	assert(*i == Telefonema("4", 1234));
	++i;
	assert(i == lista.fim());
    }

    {
	ListaDeTelefonema::Iterador i = lista.primeiro();
	++i;
	++i;
	lista.remove(i);
	assert(lista.comprimento() == 4);
	assert(*i == Telefonema("3", 123));
    }

    {
	ListaDeTelefonema::Iterador i = lista.primeiro();
	assert(i == lista.primeiro());
	assert(*i == Telefonema("1", 1));
	++i;
	assert(*i == Telefonema("10", 10));
	++i;
	assert(*i == Telefonema("3", 123));
	++i;
	assert(i == lista.ultimo());
	assert(*i == Telefonema("4", 1234));
	++i;
	assert(i == lista.fim());
    }

    lista.tiraDaFrente();
    lista.tiraDeTras();
    assert(lista.comprimento() == 2);
    assert(lista.frente() == Telefonema("10", 10));
    assert(lista.tras() == Telefonema("3", 123));

    {
	ListaDeTelefonema::Iterador i = lista.primeiro();
	assert(*i == Telefonema("10", 10));
	++i;
	assert(*i == Telefonema("3", 123));
	++i;
	assert(i == lista.fim());
    }

    assert(not lista.estaVazia());

    lista.tiraDaFrente();
    lista.tiraDeTras();
    assert(lista.comprimento() == 0);
    assert(lista.estaVazia());

    lista.poeNaFrente(Telefonema("2", 12));
    lista.poeAtras(Telefonema("3", 123));
    lista.poeNaFrente(Telefonema("1", 1));
    lista.poeAtras(Telefonema("4", 1234));

    lista.insereAntes(lista.primeiraOcorrenciaDe(Telefonema("3", 123)),
		      Telefonema("21", 121));

    assert(lista.comprimento() == 5);

    {
	ListaDeTelefonema::Iterador i = lista.ultimo();
	-- --i;
	assert(*i == Telefonema("21", 121));

	++ ++i;

	i = lista.primeiraOcorrenciaDe(Telefonema("21", 121));
	lista.insereAntes(i, Telefonema("20", 120));

	assert(lista.comprimento() == 6);

	assert(*i == Telefonema("21", 121));

	--i;

	assert(*i == Telefonema("20", 120));
    }

    ListaDeTelefonema nova_lista;
    nova_lista += lista;
    // Devia ser ListaDeTelefonema nova_lista = lista;

    {
	ListaDeTelefonema::Iterador i = lista.primeiro();
	ListaDeTelefonema::Iterador j = nova_lista.primeiro();
	
	while(i != lista.fim() and j != nova_lista.fim()) {
	    assert(*i == *j);
	    ++i;
	    ++j;
	}

	assert(i == lista.fim() and j == nova_lista.fim());
    }

    nova_lista.tiraDaFrente();

    assert(lista.frente() == Telefonema("1", 1));

    lista.esvazia();
    lista += nova_lista;
    // Deveria ser lista = nova_lista;

    {
	ListaDeTelefonema::Iterador i = lista.primeiro();
	ListaDeTelefonema::Iterador j = nova_lista.primeiro();
	
	while(i != lista.fim() and j != nova_lista.fim()) {
	    assert(*i == *j);
	    ++i;
	    ++j;
	}

	assert(i == lista.fim() and j == nova_lista.fim());
    }

    ListaDeTelefonema outra_lista;
    outra_lista += nova_lista;
    // Deveria ser ListaDeTelefonema outra_lista = nova_lista;

    outra_lista += nova_lista;

    {
	ListaDeTelefonema::Iterador i = nova_lista.primeiro();
	ListaDeTelefonema::Iterador j = outra_lista.primeiro();
	
	while(i != nova_lista.fim() and j != outra_lista.fim()) {
	    assert(*i == *j);
	    ++i;
	    ++j;
	}

	assert(i == nova_lista.fim() and j != outra_lista.fim());

	i = nova_lista.primeiro();
	while(i != nova_lista.fim() and j != outra_lista.fim()) {
	    assert(*i == *j);
	    ++i;
	    ++j;
	}

	assert(i == nova_lista.fim() and j == outra_lista.fim());
    }

    ListaDeTelefonema ainda_outra_lista;
    ainda_outra_lista.transfereDe(outra_lista);

    assert(outra_lista.estaVazia());

    {
	ListaDeTelefonema::Iterador i = lista.primeiro();
	ListaDeTelefonema::Iterador j = ainda_outra_lista.primeiro();
	
	while(i != lista.fim() and j != ainda_outra_lista.fim()) {
	    assert(*i == *j);
	    ++i;
	    ++j;
	}

	assert(i == lista.fim() and j != ainda_outra_lista.fim());

	i = lista.primeiro();

	while(i != lista.fim() and j != ainda_outra_lista.fim()) {
	    assert(*i == *j);
	    ++i;
	    ++j;
	}

	assert(i == lista.fim() and j == ainda_outra_lista.fim());
    }

    lista.esvazia();
    lista.poeAtras(Telefonema("1", 1));
    lista += lista;
    lista.transfereDe(lista);

    assert(lista.comprimento() == 2);
    assert(lista.frente() == Telefonema("1", 1));
    assert(lista.tras() == Telefonema("1", 1));

    ListaDeTelefonema const lista_constante = nova_lista;

    assert(not lista_constante.estaVazia());
    assert(lista_constante.frente() == Telefonema("2", 12));
    assert(lista_constante.tras() == Telefonema("4", 1234));

    // Outros testes com const!
}

#endif // TESTE
