#include "telefonema.H"

using namespace std;

istream& operator>>(istream& canal_de_entrada, Telefonema& telefonema) 
{
    string numero;
    int duracao;
    canal_de_entrada >> numero >> duracao;

    if(not canal_de_entrada.fail())
	if(0 <= duracao)
	    telefonema = Telefonema(numero, duracao);
	else
	    canal_de_entrada.setstate(ios_base::failbit);

    return canal_de_entrada;
}

#ifdef TESTE

#include <fstream>

int main()
{
    Telefonema t1;

    assert(t1.numero() == "");
    assert(t1.duracao() == 0);

    Telefonema t2("1", 1);

    assert(t2.numero() == "1");
    assert(t2.duracao() == 1);

    ofstream saida("teste.txt");
    t1.guardaEm(saida);
    saida << t2 << endl;

    assert(saida.good());

    saida.close();

    ifstream entrada("teste.txt");
    
    Telefonema t3(entrada);
    Telefonema t4;
    entrada >> t4;

    entrada.close();

    assert(t3 == t1);

    assert(not (t4 != t2));
}

#endif // TESTE
