#ifndef ALUNO_H
#define ALUNO_H

#include <string>
#include <iostream>

/** Representa um aluno.
    @invariant 0 <= numero_. */
class Aluno {
  public:
    /** Constri um aluno com nome e nmero dados.  Note-se que no 
	boa ideia que este construtor funcione como construtor por
	omisso, mas isso implicaria algumas alteraes adicionais na
	classe ListaDeAluno que requerem matria que no  conveniente
	introduzir neste momento.
	@pre 0 <= numero.
	@post nome() = nome and numero() = numero. */
    Aluno(std::string const& nome = "", int const numero = 0);

    /** Devolve o nome do aluno.
	@pre V.
	@post nome  o nome do aluno. */
    std::string const& nome() const;

    /** Devolve o nmero do aluno.
	@pre V.
	@post numero  o nmero do aluno. */
    int numero() const;

  private:
    std::string nome_;
    int numero_;

    /** Indica se a condio invariante da classe se verifica.
	@pre V.
	@post cumpreInvariante = 0 <= numero_. */
    bool cumpreInvariante() const;
};

/** Indica se um aluno  "menor" que outro, ou seja, se tem um nmero
    inferior ao outro. 
    @pre V.
    @post operador< = um_aluno.numero() < outro_aluno.numero(). */
bool operator<(Aluno const& um_aluno, Aluno const& outro_aluno);

/** Indica se um aluno  "maior" que outro, ou seja, se tem um nmero
    superior ao outro. 
    @pre V.
    @post operador> = um_aluno.numero() > outro_aluno.numero(). */
bool operator>(Aluno const& um_aluno, Aluno const& outro_aluno);

/** Indica se um aluno  "menor ou igual" que outro, ou seja, se tem
    um nmero inferior ou igual ao outro.
    @pre V.
    @post operador<= = um_aluno.numero() <= outro_aluno.numero(). */
bool operator<=(Aluno const& um_aluno, Aluno const& outro_aluno);

/** Indica se um aluno  "maior ou igual" que outro, ou seja, se tem
    um nmero superior ou igual ao outro.
    @pre V.
    @post operador>= = um_aluno.numero() >= outro_aluno.numero(). */
bool operator>=(Aluno const& um_aluno, Aluno const& outro_aluno);

/** Indica se um aluno  "diferente" de outro, ou seja, se tem um nmero
    diferente do outro. 
    @pre V.
    @post operador!= = um_aluno.numero() != outro_aluno.numero(). */
bool operator!=(Aluno const& um_aluno, Aluno const& outro_aluno);

/** Indica se um aluno  "igual" a outro, ou seja, se tem um nmero
    igual ao outro. 
    @pre V.
    @post operador== = um_aluno.numero() == outro_aluno.numero(). */
bool operator==(Aluno const& um_aluno, Aluno const& outro_aluno);

/** Insere informao sobre um aluno num canal.
    @pre V.
    @post saida.fail() ou (saida.fail() e saida tem (nome, numero)
    onde nome e numero so o nome e o nmero do aluno. */
std::ostream& operator<<(std::ostream& saida, Aluno const& aluno);

#include "aluno_impl.H"

#endif // ALUNO_H
