#include <cassert>

inline Aluno::Aluno(std::string const& nome, int const numero) 
    : nome_(nome), numero_(numero) 
{
    assert(0 <= numero);

    assert(cumpreInvariante());
}

inline std::string const& Aluno::nome() const 
{
    assert(cumpreInvariante());

    return nome_;
}

inline int Aluno::numero() const 
{
    assert(cumpreInvariante());

    return numero_;
}

inline bool Aluno::cumpreInvariante() const
{
    return 0 <= numero_;
}

inline bool operator<(Aluno const& um_aluno, Aluno const& outro_aluno) 
{
    return um_aluno.numero() < outro_aluno.numero();
}

inline bool operator>(Aluno const& um_aluno, Aluno const& outro_aluno) 
{
    return outro_aluno < um_aluno;
}

inline bool operator<=(Aluno const& um_aluno, Aluno const& outro_aluno) 
{
    return not (um_aluno > outro_aluno);
}

inline bool operator>=(Aluno const& um_aluno, Aluno const& outro_aluno) 
{
    return not (um_aluno < outro_aluno);
}

inline bool operator!=(Aluno const& um_aluno, Aluno const& outro_aluno) 
{
    return um_aluno < outro_aluno or um_aluno > outro_aluno;
}

inline bool operator==(Aluno const& um_aluno, Aluno const& outro_aluno) 
{
    return not (um_aluno != outro_aluno);
}

inline std::ostream& operator<<(std::ostream& saida, Aluno const& aluno) 
{
    return saida << '(' << aluno.nome() << ", " << aluno.numero() << ')';
}
