#include "lista_de_ponteiro_aluno.H"

/* Aqui podia-se resolver o problema de vrias formas.	Com
   iteradores, por exemplo.  Ou chamando tiraDaFrente() at a lista
   estar vazia.	 A soluo escolhida  da baixo nvel, e  tambm mais
   eficiente...	 Mas  a que exige maiores alteraes se se mudar a
   implementao da lista... */
void ListaDePonteiroAluno::esvazia()
{
    assert(cumpreInvariante());

    numero_de_itens = 0;

    // Destruir elos dinmicos:
    for(Elo* elo = elo_inicial->seguinte; elo != elo_final; ) {
	Elo* seguinte = elo->seguinte;
	delete elo;
	elo = seguinte;
    }

    // A cadeia duplamente ligada tem de ficar vazia:
    elo_inicial->seguinte = elo_final;
    elo_final->anterior = elo_inicial;

    assert(cumpreInvariante());
}

ListaDePonteiroAluno& 
ListaDePonteiroAluno::operator+=(ListaDePonteiroAluno const& outra_lista)
{
    assert(cumpreInvariante());
    assert(outra_lista.cumpreInvariante());

    if(this != &outra_lista)
	for(Elo* elo = outra_lista.elo_inicial->seguinte;
	    elo != outra_lista.elo_final; elo = elo->seguinte)
	    poeAtras(elo->item);
    else {
	Elo* const ultimo_elo = outra_lista.elo_final->anterior;
	for(Elo* elo = outra_lista.elo_inicial->seguinte;
	    elo != ultimo_elo->seguinte; elo = elo->seguinte)
	    poeAtras(elo->item);
    }

    assert(cumpreInvariante());

    return *this;
}

ListaDePonteiroAluno::Iterador 
ListaDePonteiroAluno::primeiraOcorrenciaDe(Item const& item)
{
    Iterador i = primeiro();
    while(i != fim() and *i != item)
	++i;
    return i;
}

ListaDePonteiroAluno::Iterador 
ListaDePonteiroAluno::ultimaOcorrenciaDe(Item const& item)
{
    Iterador i = ultimo();
    while(i != inicio() and *i != item)
	--i;
    return i;
}

std::ostream& operator<<(std::ostream& saida, ListaDePonteiroAluno& lista)
{
    saida << '(';
    for(ListaDePonteiroAluno::Iterador i = lista.primeiro(); i != lista.fim();
	++i)
    {
	saida << *i;
	if(i != lista.ultimo())
	    saida << ",";
    }
    return saida << ')';
}


#ifdef TESTE

/* Tal como esto implementadas as listas, este teste tem obrigao de falhar!
   Ser que consegue descobrir porqu?	*/

// Teste invlido e difcil de adaptar para ponteiros!  No usar!

#include <iostream>
#include <fstream>

using namespace std;

/** Teste de unidade do TAD ListaDePonteiroAlunos.  Verifica o bom
    funcionamento de todas as operaes sem excepo! */
int main()
{
    ListaDePonteiroAluno lista;

    assert(lista.comprimento() == 0);

    lista.poeNaFrente(Aluno("2", 12));
    lista.poeAtras(Aluno("3", 123));
    lista.poeNaFrente(Aluno("1", 1));
    lista.poeAtras(Aluno("4", 1234));

    assert(lista.comprimento() == 4);

    assert(lista.frente() == Aluno("1", 1));
    assert(lista.tras() == Aluno("4", 1234));

    // No se pode reaproveitar os iteradores, pois no so
    // atribuveis entre si.  Por isso cada bloco de teste  colocado
    // entre chavetas:

    {
	ListaDePonteiroAluno::Iterador i = lista.primeiro();
	assert(i == lista.primeiro());
	assert(*i == Aluno("1", 1));
	++i;
	assert(*i == Aluno("2", 12));
	ListaDePonteiroAluno::Iterador j1 = ++i;
	assert(j1 == i);
	assert(*i == Aluno("3", 123));
	ListaDePonteiroAluno::Iterador j2 = i++;
	assert(j2 == j1);
	assert(i == lista.ultimo());
	assert(*i == Aluno("4", 1234));
	++i;
	assert(i == lista.fim());
    }

    assert(lista.ultimo() != lista.inicio());
    lista.esvazia();
    assert(lista.estaVazia());
    assert(lista.comprimento() == 0);
    assert(lista.primeiro() == lista.fim());
    assert(lista.ultimo() == lista.inicio());

    lista.poeNaFrente(Aluno("2", 12));
    lista.poeAtras(Aluno("3", 123));
    lista.poeNaFrente(Aluno("1", 1));
    lista.poeAtras(Aluno("4", 1234));

    {
	ListaDePonteiroAluno::Iterador i = lista.ultimo();
	assert(i == lista.ultimo());
	++i;
	assert(i == lista.fim());
	--i;
	assert(*i == Aluno("4", 1234));
	ListaDePonteiroAluno::Iterador j1 = --i;
	assert(j1 == i);
	assert(*i == Aluno("3", 123));
	ListaDePonteiroAluno::Iterador j2 = i--;
	assert(j2 == j1);
	assert(*i == Aluno("2", 12));
	--i;
	assert(i == lista.primeiro());
	assert(*i == Aluno("1", 1));
	--i;
	assert(i == lista.inicio());
	++i;
	assert(i == lista.primeiro());
    }

    {
	ListaDePonteiroAluno::Iterador i = lista.primeiro();
	++i;
	lista.insereAntes(i, Aluno("10", 10));
	assert(lista.comprimento() == 5);
	assert(*i == Aluno("2", 12));
	--i;
	--i;
	assert(i == lista.primeiro());
	assert(*i == Aluno("1", 1));
	++i;
	assert(*i == Aluno("10", 10));
	++i;
	assert(*i == Aluno("2", 12));
	++i;
	assert(*i == Aluno("3", 123));
	++i;
	assert(i == lista.ultimo());
	assert(*i == Aluno("4", 1234));
	++i;
	assert(i == lista.fim());
    }

    {
	ListaDePonteiroAluno::Iterador i = lista.primeiro();
	++i;
	++i;
	lista.remove(i);
	assert(lista.comprimento() == 4);
	assert(*i == Aluno("3", 123));
    }

    {
	ListaDePonteiroAluno::Iterador i = lista.primeiro();
	assert(i == lista.primeiro());
	assert(*i == Aluno("1", 1));
	++i;
	assert(*i == Aluno("10", 10));
	++i;
	assert(*i == Aluno("3", 123));
	++i;
	assert(i == lista.ultimo());
	assert(*i == Aluno("4", 1234));
	++i;
	assert(i == lista.fim());
    }

    lista.tiraDaFrente();
    lista.tiraDeTras();
    assert(lista.comprimento() == 2);
    assert(lista.frente() == Aluno("10", 10));
    assert(lista.tras() == Aluno("3", 123));

    {
	ListaDePonteiroAluno::Iterador i = lista.primeiro();
	assert(*i == Aluno("10", 10));
	++i;
	assert(*i == Aluno("3", 123));
	++i;
	assert(i == lista.fim());
    }

    assert(not lista.estaVazia());

    lista.tiraDaFrente();
    lista.tiraDeTras();
    assert(lista.comprimento() == 0);
    assert(lista.estaVazia());

    lista.poeNaFrente(Aluno("2", 12));
    lista.poeAtras(Aluno("3", 123));
    lista.poeNaFrente(Aluno("1", 1));
    lista.poeAtras(Aluno("4", 1234));

    lista.insereAntes(lista.primeiraOcorrenciaDe(Aluno("3", 123)),
		      Aluno("21", 121));

    assert(lista.comprimento() == 5);

    {
	ListaDePonteiroAluno::Iterador i = lista.ultimo();
	-- --i;
	assert(*i == Aluno("21", 121));

	++ ++i;

	i = lista.primeiraOcorrenciaDe(Aluno("21", 121));
	lista.insereAntes(i, Aluno("20", 120));

	assert(lista.comprimento() == 6);

	assert(*i == Aluno("21", 121));

	--i;

	assert(*i == Aluno("20", 120));
    }

    ListaDePonteiroAluno nova_lista;
    nova_lista += lista;
    // Devia ser ListaDePonteiroAluno nova_lista = lista;

    {
	ListaDePonteiroAluno::Iterador i = lista.primeiro();
	ListaDePonteiroAluno::Iterador j = nova_lista.primeiro();
	
	while(i != lista.fim() and j != nova_lista.fim()) {
	    assert(*i == *j);
	    ++i;
	    ++j;
	}

	assert(i == lista.fim() and j == nova_lista.fim());
    }

    nova_lista.tiraDaFrente();

    assert(lista.frente() == Aluno("1", 1));

    lista.esvazia();
    lista += nova_lista;
    // Deveria ser lista = nova_lista;

    {
	ListaDePonteiroAluno::Iterador i = lista.primeiro();
	ListaDePonteiroAluno::Iterador j = nova_lista.primeiro();
	
	while(i != lista.fim() and j != nova_lista.fim()) {
	    assert(*i == *j);
	    ++i;
	    ++j;
	}

	assert(i == lista.fim() and j == nova_lista.fim());
    }

    ListaDePonteiroAluno outra_lista;
    outra_lista += nova_lista;
    // Deveria ser ListaDePonteiroAluno outra_lista = nova_lista;

    outra_lista += nova_lista;

    {
	ListaDePonteiroAluno::Iterador i = nova_lista.primeiro();
	ListaDePonteiroAluno::Iterador j = outra_lista.primeiro();
	
	while(i != nova_lista.fim() and j != outra_lista.fim()) {
	    assert(*i == *j);
	    ++i;
	    ++j;
	}

	assert(i == nova_lista.fim() and j != outra_lista.fim());

	i = nova_lista.primeiro();
	while(i != nova_lista.fim() and j != outra_lista.fim()) {
	    assert(*i == *j);
	    ++i;
	    ++j;
	}

	assert(i == nova_lista.fim() and j == outra_lista.fim());
    }

    ListaDePonteiroAluno ainda_outra_lista;
    ainda_outra_lista.transfereDe(outra_lista);

    assert(outra_lista.estaVazia());

    {
	ListaDePonteiroAluno::Iterador i = lista.primeiro();
	ListaDePonteiroAluno::Iterador j = ainda_outra_lista.primeiro();
	
	while(i != lista.fim() and j != ainda_outra_lista.fim()) {
	    assert(*i == *j);
	    ++i;
	    ++j;
	}

	assert(i == lista.fim() and j != ainda_outra_lista.fim());

	i = lista.primeiro();

	while(i != lista.fim() and j != ainda_outra_lista.fim()) {
	    assert(*i == *j);
	    ++i;
	    ++j;
	}

	assert(i == lista.fim() and j == ainda_outra_lista.fim());
    }

    lista.esvazia();
    lista.poeAtras(Aluno("1", 1));
    lista += lista;
    lista.transfereDe(lista);

    assert(lista.comprimento() == 2);
    assert(lista.frente() == Aluno("1", 1));
    assert(lista.tras() == Aluno("1", 1));

    ListaDePonteiroAluno const lista_constante = nova_lista;

    assert(not lista_constante.estaVazia());
    assert(lista_constante.frente() == Aluno("2", 12));
    assert(lista_constante.tras() == Aluno("4", 1234));

    // Outros testes com const!
}

#endif // TESTE
