#include "lista_de_aluno.H"

/* Aqui podia-se resolver o problema de vrias formas.	Com
   iteradores, por exemplo.  Ou chamando tiraDaFrente() at a lista
   estar vazia.	 A soluo escolhida  da baixo nvel, e  tambm mais
   eficiente...	 Mas  a que exige maiores alteraes se se mudar a
   implementao da lista... */
void ListaDeAluno::esvazia()
{
    assert(cumpreInvariante());

    numero_de_itens = 0;

    // Destruir elos dinmicos:
    for(Elo* elo = elo_inicial->seguinte; elo != elo_final; ) {
	Elo* seguinte = elo->seguinte;
	delete elo;
	elo = seguinte;
    }

    // A cadeia duplamente ligada tem de ficar vazia:
    elo_inicial->seguinte = elo_final;
    elo_final->anterior = elo_inicial;

    assert(cumpreInvariante());
}

ListaDeAluno& ListaDeAluno::operator+=(ListaDeAluno const& outra_lista)
{
    assert(cumpreInvariante());
    assert(outra_lista.cumpreInvariante());

    if(this != &outra_lista)
	for(Elo* elo = outra_lista.elo_inicial->seguinte;
	    elo != outra_lista.elo_final; elo = elo->seguinte)
	    poeAtras(elo->item);
    else {
	Elo* const ultimo_elo = outra_lista.elo_final->anterior;
	for(Elo* elo = outra_lista.elo_inicial->seguinte;
	    elo != ultimo_elo->seguinte; elo = elo->seguinte)
	    poeAtras(elo->item);
    }

    assert(cumpreInvariante());

    return *this;
}

ListaDeAluno::IteradorConstante ListaDeAluno::
primeiraOcorrenciaDe(Item const& item) const
{
    IteradorConstante i = primeiro();
    while(i != fim() && *i != item)
	++i;

    return i;
}

ListaDeAluno::IteradorConstante
ListaDeAluno::ultimaOcorrenciaDe(Item const& item) const
{
    IteradorConstante i = ultimo();
    while(i != inicio() && *i != item)
	--i;

    return i;
}

ListaDeAluno::Iterador ListaDeAluno::primeiraOcorrenciaDe(Item const& item)
{
    Iterador i = primeiro();
    while(i != fim() and *i != item)
	++i;

    return i;
}

ListaDeAluno::Iterador ListaDeAluno::ultimaOcorrenciaDe(Item const& item)
{
    Iterador i = ultimo();
    while(i != inicio() and *i != item)
	--i;

    return i;
}

std::ostream& operator<<(std::ostream& saida, ListaDeAluno const& lista)
{
    saida << '(';
    for(ListaDeAluno::IteradorConstante i = lista.primeiro();
	i != lista.fim(); ++i) {
	saida << *i;
	if(i != lista.ultimo())
	    saida << ",";
    }
    return saida << ')';
}


#ifdef TESTE

/* Tal como esto implementadas as listas, este teste tem obrigao de falhar!
   Ser que consegue descobrir porqu?	*/

#include <iostream>
#include <fstream>

using namespace std;

/** Teste de unidade do TAD ListaDeAlunos.  Verifica o bom
    funcionamento de todas as operaes sem excepo! */
int main()
{
    ListaDeAluno lista;

    assert(lista.comprimento() == 0);

    lista.poeNaFrente(Aluno("2", 12));
    lista.poeAtras(Aluno("3", 123));
    lista.poeNaFrente(Aluno("1", 1));
    lista.poeAtras(Aluno("4", 1234));

    assert(lista.comprimento() == 4);

    assert(lista.frente() == Aluno("1", 1));
    assert(lista.tras() == Aluno("4", 1234));

    // No se pode reaproveitar os iteradores, pois no so
    // atribuveis entre si.  Por isso cada bloco de teste  colocado
    // entre chavetas:

    {
	ListaDeAluno::Iterador i = lista.primeiro();
	assert(i == lista.primeiro());
	assert(*i == Aluno("1", 1));
	++i;
	assert(*i == Aluno("2", 12));
	ListaDeAluno::Iterador j1 = ++i;
	assert(j1 == i);
	assert(*i == Aluno("3", 123));
	ListaDeAluno::Iterador j2 = i++;
	assert(j2 == j1);
	assert(i == lista.ultimo());
	assert(*i == Aluno("4", 1234));
	++i;
	assert(i == lista.fim());
    }

    assert(lista.ultimo() != lista.inicio());
    lista.esvazia();
    assert(lista.estaVazia());
    assert(lista.comprimento() == 0);
    assert(lista.primeiro() == lista.fim());
    assert(lista.ultimo() == lista.inicio());

    lista.poeNaFrente(Aluno("2", 12));
    lista.poeAtras(Aluno("3", 123));
    lista.poeNaFrente(Aluno("1", 1));
    lista.poeAtras(Aluno("4", 1234));

    {
	ListaDeAluno::Iterador i = lista.ultimo();
	assert(i == lista.ultimo());
	++i;
	assert(i == lista.fim());
	--i;
	assert(*i == Aluno("4", 1234));
	ListaDeAluno::Iterador j1 = --i;
	assert(j1 == i);
	assert(*i == Aluno("3", 123));
	ListaDeAluno::Iterador j2 = i--;
	assert(j2 == j1);
	assert(*i == Aluno("2", 12));
	--i;
	assert(i == lista.primeiro());
	assert(*i == Aluno("1", 1));
	--i;
	assert(i == lista.inicio());
	++i;
	assert(i == lista.primeiro());
    }

    {
	ListaDeAluno::Iterador i = lista.primeiro();
	++i;
	lista.insereAntes(i, Aluno("10", 10));
	assert(lista.comprimento() == 5);
	assert(*i == Aluno("2", 12));
	--i;
	--i;
	assert(i == lista.primeiro());
	assert(*i == Aluno("1", 1));
	++i;
	assert(*i == Aluno("10", 10));
	++i;
	assert(*i == Aluno("2", 12));
	++i;
	assert(*i == Aluno("3", 123));
	++i;
	assert(i == lista.ultimo());
	assert(*i == Aluno("4", 1234));
	++i;
	assert(i == lista.fim());
    }

    {
	ListaDeAluno::Iterador i = lista.primeiro();
	++i;
	++i;
	lista.remove(i);
	assert(lista.comprimento() == 4);
	assert(*i == Aluno("3", 123));
    }

    {
	ListaDeAluno::Iterador i = lista.primeiro();
	assert(i == lista.primeiro());
	assert(*i == Aluno("1", 1));
	++i;
	assert(*i == Aluno("10", 10));
	++i;
	assert(*i == Aluno("3", 123));
	++i;
	assert(i == lista.ultimo());
	assert(*i == Aluno("4", 1234));
	++i;
	assert(i == lista.fim());
    }

    lista.tiraDaFrente();
    lista.tiraDeTras();
    assert(lista.comprimento() == 2);
    assert(lista.frente() == Aluno("10", 10));
    assert(lista.tras() == Aluno("3", 123));

    {
	ListaDeAluno::Iterador i = lista.primeiro();
	assert(*i == Aluno("10", 10));
	++i;
	assert(*i == Aluno("3", 123));
	++i;
	assert(i == lista.fim());
    }

    assert(not lista.estaVazia());

    lista.tiraDaFrente();
    lista.tiraDeTras();
    assert(lista.comprimento() == 0);
    assert(lista.estaVazia());

    lista.poeNaFrente(Aluno("2", 12));
    lista.poeAtras(Aluno("3", 123));
    lista.poeNaFrente(Aluno("1", 1));
    lista.poeAtras(Aluno("4", 1234));

    lista.insereAntes(lista.primeiraOcorrenciaDe(Aluno("3", 123)),
		      Aluno("21", 121));

    assert(lista.comprimento() == 5);

    {
	ListaDeAluno::Iterador i = lista.ultimo();
	-- --i;
	assert(*i == Aluno("21", 121));

	++ ++i;

	i = lista.primeiraOcorrenciaDe(Aluno("21", 121));
	lista.insereAntes(i, Aluno("20", 120));

	assert(lista.comprimento() == 6);

	assert(*i == Aluno("21", 121));

	--i;

	assert(*i == Aluno("20", 120));
    }

    ListaDeAluno nova_lista;
    nova_lista += lista;
    // Devia ser ListaDeAluno nova_lista = lista;

    {
	ListaDeAluno::Iterador i = lista.primeiro();
	ListaDeAluno::Iterador j = nova_lista.primeiro();
	
	while(i != lista.fim() and j != nova_lista.fim()) {
	    assert(*i == *j);
	    ++i;
	    ++j;
	}

	assert(i == lista.fim() and j == nova_lista.fim());
    }

    nova_lista.tiraDaFrente();

    assert(lista.frente() == Aluno("1", 1));

    lista.esvazia();
    lista += nova_lista;
    // Deveria ser lista = nova_lista;

    {
	ListaDeAluno::Iterador i = lista.primeiro();
	ListaDeAluno::Iterador j = nova_lista.primeiro();
	
	while(i != lista.fim() and j != nova_lista.fim()) {
	    assert(*i == *j);
	    ++i;
	    ++j;
	}

	assert(i == lista.fim() and j == nova_lista.fim());
    }

    ListaDeAluno outra_lista;
    outra_lista += nova_lista;
    // Deveria ser ListaDeAluno outra_lista = nova_lista;

    outra_lista += nova_lista;

    {
	ListaDeAluno::Iterador i = nova_lista.primeiro();
	ListaDeAluno::Iterador j = outra_lista.primeiro();
	
	while(i != nova_lista.fim() and j != outra_lista.fim()) {
	    assert(*i == *j);
	    ++i;
	    ++j;
	}

	assert(i == nova_lista.fim() and j != outra_lista.fim());

	i = nova_lista.primeiro();
	while(i != nova_lista.fim() and j != outra_lista.fim()) {
	    assert(*i == *j);
	    ++i;
	    ++j;
	}

	assert(i == nova_lista.fim() and j == outra_lista.fim());
    }

    ListaDeAluno ainda_outra_lista;
    ainda_outra_lista.transfereDe(outra_lista);

    assert(outra_lista.estaVazia());

    {
	ListaDeAluno::Iterador i = lista.primeiro();
	ListaDeAluno::Iterador j = ainda_outra_lista.primeiro();
	
	while(i != lista.fim() and j != ainda_outra_lista.fim()) {
	    assert(*i == *j);
	    ++i;
	    ++j;
	}

	assert(i == lista.fim() and j != ainda_outra_lista.fim());

	i = lista.primeiro();

	while(i != lista.fim() and j != ainda_outra_lista.fim()) {
	    assert(*i == *j);
	    ++i;
	    ++j;
	}

	assert(i == lista.fim() and j == ainda_outra_lista.fim());
    }

    lista.esvazia();
    lista.poeAtras(Aluno("1", 1));
    lista += lista;
    lista.transfereDe(lista);

    assert(lista.comprimento() == 2);
    assert(lista.frente() == Aluno("1", 1));
    assert(lista.tras() == Aluno("1", 1));

    ListaDeAluno lista_recomecada;

    lista_recomecada.poeNaFrente(Aluno("2", 12));
    lista_recomecada.poeAtras(Aluno("3", 123));
    lista_recomecada.poeNaFrente(Aluno("1", 1));
    lista_recomecada.poeAtras(Aluno("4", 1234));

    ListaDeAluno const lista_constante = lista_recomecada;

    assert(not lista_constante.estaVazia());
    assert(lista_constante.frente() == Aluno("1", 1));
    assert(lista_constante.tras() == Aluno("4", 1234));

    {
	ListaDeAluno::IteradorConstante i = lista_constante.primeiro();
	ListaDeAluno::Iterador j = lista_recomecada.primeiro();
	
	while(i != lista_constante.fim() and j != lista_recomecada.fim()) {
	    assert(*i == *j);
	    ++i;
	    ++j;
	}
	
	assert(i == lista_constante.fim() and j == lista_recomecada.fim());
    }

    {
	ListaDeAluno::IteradorConstante i = lista_constante.primeiro();
	ListaDeAluno::Iterador j = lista_recomecada.primeiro();
	
	while(i != lista_constante.fim() and j != lista_recomecada.fim()) {
	    assert(*i == *j);
	    i++;
	    ++j;
	}
	
	assert(i == lista_constante.fim() and j == lista_recomecada.fim());
    }

    ListaDeAluno::Iterador i = lista_recomecada.primeiro();
    ListaDeAluno::IteradorConstante j = lista_recomecada.primeiro();

    assert(i == j);

    lista_recomecada.insereAntes(j, Aluno("5", 12345));
    --i;
    assert(*i == Aluno("5", 12345));
    assert(*j == Aluno("1", 1));

    lista_recomecada.remove(j);
    ++i;
    assert(*i == Aluno("2", 12));
    assert(*j == Aluno("2", 12));

    ListaDeAluno::IteradorConstante const ic = i;
    ListaDeAluno::Iterador const jc = ++i;
    lista_recomecada.tiraDaFrente();
    assert(lista_recomecada.comprimento() == 3);

    lista_recomecada.remove(ic);
    lista_recomecada.remove(jc);

    assert(lista_recomecada.comprimento() == 1);
    assert(lista_recomecada.frente() == Aluno("4", 1234));
    assert(lista_recomecada.tras() == Aluno("4", 1234));
}

#endif // TESTE
