#include "pilha_de_int.H"

PilhaDeInt::Item* PilhaDeInt::novosItens(int capacidade) const
{
    assert(numero_de_itens <= capacidade);

    Item* const novos_itens = new Item[capacidade];

    try {
	for(int i = 0; i != numero_de_itens; ++i)
	    novos_itens[i] = itens[i];
    } catch(...) {
	delete[] novos_itens;
	
	throw;
    }

    return novos_itens;
}

int const PilhaDeInt::capacidade_inicial;

#ifdef TESTE

int main()
{
    int const n = 10000;
    PilhaDeInt pilha;

    assert(pilha.estaVazia());
    assert(pilha.altura() == 0);

    for(int i = 0; i != n; ++i) {
	assert(pilha.altura() == i);
	pilha.poe(i);
	assert(pilha.topo() == i);
    }

    assert(not pilha.estaVazia());
    assert(pilha.altura() == n);

    PilhaDeInt outra_pilha = pilha;

    assert(not outra_pilha.estaVazia());
    assert(outra_pilha.altura() == n);

    for(int i = n - 1; i != -1; --i) {
	assert(pilha.topo() == i);
	pilha.tiraItem();
	assert(pilha.altura() == i);
    }

    assert(pilha.estaVazia());
    assert(pilha.altura() == 0);

    assert(not outra_pilha.estaVazia());
    assert(outra_pilha.altura() == n);

    for(int i = n - 1; i != -1; --i) {
	assert(outra_pilha.topo() == i);
	outra_pilha.tiraItem();
	assert(outra_pilha.altura() == i);
    }

    assert(pilha.estaVazia());
    assert(pilha.altura() == 0);

    pilha.poe(11);

    PilhaDeInt const pilha_constante = pilha;

    assert(pilha_constante.altura() == 1);
    assert(not pilha_constante.estaVazia());
    assert(pilha_constante.topo() == 11);
}

#endif // TESTE
