#include <cassert>
#include <algorithm>

inline PilhaDeInt::PilhaDeInt()
    : capacidade_actual(capacidade_inicial),
      itens(new Item[capacidade_actual]),
      numero_de_itens(0)
{

    assert(cumpreInvariante());
}

inline PilhaDeInt::PilhaDeInt(PilhaDeInt const& original)
    : capacidade_actual(original.capacidade_actual),
      itens(original.novosItens(capacidade_actual)),
      numero_de_itens(original.numero_de_itens)
{

    assert(cumpreInvariante());
}

inline PilhaDeInt::~PilhaDeInt()
{
    assert(cumpreInvariante());

    delete[] itens;
}

PilhaDeInt& PilhaDeInt::operator=(PilhaDeInt modelo)
{
    assert(cumpreInvariante());

    trocaCom(modelo);

    assert(cumpreInvariante());

    return *this;
}

void PilhaDeInt::trocaCom(PilhaDeInt& outra_pilha)
{
    assert(cumpreInvariante());
    assert(outra_pilha.cumpreInvariante());

    std::swap(capacidade_actual, outra_pilha.capacidade_actual);
    std::swap(itens, outra_pilha.itens);
    std::swap(numero_de_itens, outra_pilha.numero_de_itens);

    assert(cumpreInvariante());
    assert(outra_pilha.cumpreInvariante());
}

inline bool PilhaDeInt::estaVazia() const
{
    assert(cumpreInvariante());
    return altura() == 0;
}

inline int PilhaDeInt::altura() const
{
    assert(cumpreInvariante());
    return numero_de_itens;
}

inline PilhaDeInt::Item const& PilhaDeInt::topo() const
{
    assert(cumpreInvariante());
    assert(not estaVazia());

    return itens[numero_de_itens - 1];
}

inline PilhaDeInt::Item& PilhaDeInt::topo()
{
    assert(cumpreInvariante());
    assert(not estaVazia());

    return itens[numero_de_itens - 1];
}

inline void PilhaDeInt::poe(Item const& novo_item)
{
    assert(cumpreInvariante());

    if(numero_de_itens == capacidade_actual) {
	Item* const novos_itens = novosItens(capacidade_actual * 2);

	capacidade_actual *= 2;

	delete[] itens;

	itens = novos_itens;
    }

    itens[numero_de_itens] = novo_item;
    ++numero_de_itens;

    assert(cumpreInvariante());
}

inline void PilhaDeInt::tiraItem()
{
    assert(cumpreInvariante());
    assert(not estaVazia());

    --numero_de_itens;

    if(numero_de_itens <= capacidade_actual / 4) {
	int nova_capacidade =
	    std::max(capacidade_actual / 2, capacidade_inicial);

	try {
	    Item* const novos_itens = novosItens(nova_capacidade);

	    capacidade_actual = nova_capacidade;

	    delete[] itens;

	    itens = novos_itens;
	} catch(...) {
	}
    }

    assert(cumpreInvariante());
}

inline bool PilhaDeInt::cumpreInvariante() const
{
    return itens != 0 and
	   capacidade_inicial <= capacidade_actual and
	   0 <= numero_de_itens <= capacidade_actual;
}
