#include "fila_de_int.H"

#ifdef TESTE

#include <iostream>

using namespace std;

int main()
{
    int const numero_de_insercoes = 1000;

    FilaDeInt fila;

    assert(fila.estaVazia());
    assert(fila.comprimento() == 0);

    for(int valor = 0; valor != numero_de_insercoes; ++valor) {
	assert(fila.comprimento() == valor);
	fila.poe(valor);
	assert(fila.frente() == 0);
    }

    assert(not fila.estaVazia());
    assert(fila.comprimento() == numero_de_insercoes);

    assert(fila.frente() == 0);

    fila.frente() = 30;

    assert(fila.frente() == 30);

    fila.frente() = 0;

    int valor = 0;
    while(not fila.estaVazia()) {
	assert(fila.frente() == valor);
	assert(fila.comprimento() == numero_de_insercoes - valor);
	fila.tira();
	++valor;
    }

    assert(fila.estaVazia());
    assert(fila.comprimento() == 0);

    fila.poe(11);
    fila.poe(12);

    FilaDeInt const fila_constante = fila;

    assert(fila_constante.frente() == 11);
}

#endif // TESTE
