#ifndef FILA_DE_INT_H
#define FILA_DE_INT_H

#include "lista_de_int.H"

/** Representa filas (de espera) de inteiros.
    @invariant V. */
class FilaDeInt : private ListaDeInt {
public:
    /** @brief Sinnimo de int.  Usa-se para simplificar a tarefa
        de criar filas com itens de outros tipos. */
    using ListaDeInt::Item;

    /// Indica se a fila est vazia.
    using ListaDeInt::estaVazia;

    /// Devolve o comprimento da fila, ou seja, o seu nmero de itens.
    using ListaDeInt::comprimento;

    /** @brief Devolve referncia para o item na frente da fila.  A
	referncia devolvida  constante se a fila o for.
	@pre estaVazia(). */
    using ListaDeInt::frente;

    /** @brief Poe novo item na traseira da fila.
	@pre V. */
    void poe(Item const& item);

    /** @brief Tira o item da frente da fila.
	@pre estaVazia(). */
    void tira();

private:
    /** Indica se a condio invariante de instncia da classe se
	verifica. */
    bool cumpreInvariante() const;
};

#include "fila_de_int_impl.H"

#endif // FILA_DE_INT_H
