#ifndef OUTROS_FILMES_H
#define OUTROS_FILMES_H

#include <iosfwd>
#include <string>

#include "filme.H"

/** Representa filmes estrangeiros. 
    @invariant pais_ e lingua_ no tm '\n'. */
class FilmeEstrangeiro : public Filme {
public:
    /** Constri novo filme estrangeiro com nome, realizador, durao,
	pas e lngua dados.
	@pre 0 <= duracao e nome, realizador, pais e lingua no tm '\n'.
	@post nome() = nome e realizador() = realizador e duracao() =
	duracao e pais() = pais e lingua() = lingua. */
    FilmeEstrangeiro(std::string const& nome, std::string const& realizador,
                     int duracao, 
                     std::string const& pais, std::string const& lingua);

    /** Constri novo filme estrangeiro com informao extrada do canal de
	entrada. 
	@pre entrada.
	@post *this tem informao extrada do canal de entrada. */
    explicit FilmeEstrangeiro(std::istream& entrada);
    
    /** Devolve o pais de origem do filme.
	@pre V.
	@post pais = pas de origem do filme. */
    std::string const& pais() const;

    /** Devolve a lngua do filme.
	@pre V.
	@post lingua = lngua do filme. */
    std::string const& lingua() const;
    
    /** Mostra informao sobre o filme no canal dado num formato
	agradvel  vista.
	@pre V.
	@post saida contm a informao sobre o filme. */
    virtual void mostraEm(std::ostream& saida) const;

    /** Guarda informao sobre o filme no canal dado num formato
	apropriado a futuros carregamentos.
	@pre saida.
	@post saida contm a informao sobre o filme. */
    // virtual void guardaEm(std::ostream& saida) const;

    /** Le informao sobre o filme do canal dado assumindo que este
	est ligado a um ser humano (e.g., leitura do teclado).
	@pre V.
	@post *this contm a informao sobre o filme lida do canal de
	entrada. */
    // virtual void leDe(std::istream& entrada);

    /** Carrega informao sobre o filme do canal dado assumindo que este
	est ligado no formato usado pela operao carrega().
	@pre entrada.
	@post *this contm a informao sobre o filme carregada do canal de
	entrada. */
    virtual void carregaDe(std::istream& entrada);
    
private:
    std::string lingua_;
    std::string pais_;

    /** Indica se a condio invariante da classe se verifica.
	@pre V.
	@post cumpreInvariante = V. */
    bool cumpreInvariante() const;
};

/** Representa filmes com edio do realizador. 
    @invariant alteracoes_ no tem '\n'. */
class EdicaoDoRealizador : public Filme {
public:
    /** Constri novo filme com edio do realizador com nome,
	realizador, durao, e alteraes dados.
	@pre 0 <= duracao e nome, realizador e alteracoes no tm '\n'.
	@post nome() = nome e realizador() = realizador e duracao() =
	duracao e alteracoes() = alteracoes. */
    EdicaoDoRealizador(std::string const& nome, std::string const& realizador,
                       int duracao, 
                       std::string const& alteracoes);

    /** Constri novo filme com edio do realizador com informao
	extrada do canal de entrada. 
	@pre entrada.
	@post *this tem informao extrada do canal de entrada. */
    explicit EdicaoDoRealizador(std::istream& entrada);
    
    /** Devolve as alteraes sofridas pelo filme.
	@pre V.
	@post alteracoes = alteraes sofridas pelo filme. */
    std::string alteracoes() const;
    
    /** Mostra informao sobre o filme no canal dado num formato
	agradvel  vista.
	@pre V.
	@post saida contm a informao sobre o filme. */
    void mostraEm(std::ostream& saida) const;

    /** Guarda informao sobre o filme no canal dado num formato
	apropriado a futuros carregamentos.
	@pre saida.
	@post saida contm a informao sobre o filme. */
    // virtual void guardaEm(std::ostream& saida) const;

    /** Le informao sobre o filme do canal dado assumindo que este
	est ligado a um ser humano (e.g., leitura do teclado).
	@pre V.
	@post *this contm a informao sobre o filme lida do canal de
	entrada. */
    // virtual void leDe(std::istream& entrada);

    /** Carrega informao sobre o filme do canal dado assumindo que este
	est ligado no formato usado pela operao carrega().
	@pre entrada.
	@post *this contm a informao sobre o filme carregada do canal de
	entrada. */
    void carregaDe(std::istream& entrada);
    
private:
    std::string alteracoes_;

    /** Indica se a condio invariante da classe se verifica.
	@pre V.
	@post cumpreInvariante = V. */
    bool cumpreInvariante() const;
};

#include "outros_filmes_impl.H"

#endif // OUTROS_FILMES_H
