#ifndef TERMO_H
#define TERMO_H

#include <string>

/** Representa termos de uma expresso.
    @invariant V. */
class Termo {
public:
    /** Destrutor abstracto marca classe como abstracta. */
    virtual ~Termo() = 0;

    /** Devolve o valor do termo.
	@pre V.
	@post valor = valor do termo. */
    virtual double valor() const = 0;

    /** Devolve o termo representado numa cadeia de caracteres.  O termo  
	representado como uma expresso com todos os seus parnteses.
	@pre V.
	@post comoCadeia = expresso com todos os parnteses correspondente ao
	      termo. */
    virtual std::string const comoCadeia() const = 0;

private:
    /** Indica se a condio invariante da classe se verifica.
	@pre V.
	@post cumpreInvariante = V. */
    bool cumpreInvariante() const;
};

#include "termo_impl.H"

#endif // TERMO_H
