#include <cassert>
#include <cmath>
#include <sstream>

inline Adicao::Adicao(std::auto_ptr<Termo> termo_esquerdo, 
		      std::auto_ptr<Termo> termo_direito)
    : termo_esquerdo(termo_esquerdo), termo_direito(termo_direito) 
{
    // No  possvel verificar a pr-condio, porque neste ponto 
    // j os parmetros foram alterados!
    // assert(termo_esquerdo.get() != 0 and termo_direito.get() != 0);

    assert(cumpreInvariante());
}

inline double Adicao::valor() const
{
    assert(cumpreInvariante());

    return termo_esquerdo->valor() + termo_direito->valor();
}

inline std::string const Adicao::comoCadeia() const
{
    assert(cumpreInvariante());

    return '(' + termo_esquerdo->comoCadeia() + " + " + 
	termo_direito->comoCadeia() + ')';
}

inline bool Adicao::cumpreInvariante() const
{
    return termo_esquerdo.get() != 0 and termo_direito.get() != 0;
}

inline Produto::Produto(std::auto_ptr<Termo> termo_esquerdo, 
			std::auto_ptr<Termo> termo_direito)
    : termo_esquerdo(termo_esquerdo), termo_direito(termo_direito) 
{
    // No  possvel verificar a pr-condio, porque neste ponto 
    // j os parmetros foram alterados!
    // assert(termo_esquerdo.get() != 0 and termo_direito.get() != 0);

    assert(cumpreInvariante());
}

inline double Produto::valor() const
{
    assert(cumpreInvariante());

    return termo_esquerdo->valor() * termo_direito->valor();
}

inline std::string const Produto::comoCadeia() const
{
    assert(cumpreInvariante());

    return '(' + termo_esquerdo->comoCadeia() + " * " + 
	termo_direito->comoCadeia() + ')';
}

inline bool Produto::cumpreInvariante() const
{
    return termo_esquerdo.get() != 0 and termo_direito.get() != 0;
}


inline Potencia::Potencia(std::auto_ptr<Termo> termo_esquerdo, 
			  std::auto_ptr<Termo> termo_direito)
    : termo_esquerdo(termo_esquerdo), termo_direito(termo_direito) 
{
    // No  possvel verificar a pr-condio, porque neste ponto 
    // j os parmetros foram alterados!
    // assert(termo_esquerdo.get() != 0 and termo_direito.get() != 0);

    assert(cumpreInvariante());
}

inline double Potencia::valor() const
{
    assert(cumpreInvariante());

    return pow(termo_esquerdo->valor(), termo_direito->valor());
}

inline std::string const Potencia::comoCadeia() const
{
    assert(cumpreInvariante());

    return '(' + termo_esquerdo->comoCadeia() + "^" + 
	termo_direito->comoCadeia() + ')';
}

inline bool Potencia::cumpreInvariante() const
{
    return termo_esquerdo.get() != 0 and termo_direito.get() != 0;
}


inline Valor::Valor(double valor)
    : valor_(valor)
{
    assert(cumpreInvariante());
}

inline double Valor::valor() const
{
    assert(cumpreInvariante());

    return valor_;
}

inline std::string const Valor::comoCadeia() const
{
    assert(cumpreInvariante());

    std::ostringstream saida;
    saida << valor();

    return saida.str();
}

inline bool Valor::cumpreInvariante() const
{
    return true;
}

