#include <list>

#include <Slang/slang.H>

#include "glifo.H"
#include "caractere.H"
#include "sorriso.H"

using namespace std;

using namespace Slang;

void mostra(list<Glifo*> glifos)
{
    ecra << cursor(ecra.cursor().linha() + 1, 0);
    for(list<Glifo*>::iterator i = glifos.begin(); i != glifos.end(); ++i) {
	if(ecra.cursor().coluna() + (*i)->largura() >= 
	   ecra.dimensao().colunas()
	   and (*i)->largura() < ecra.dimensao().colunas())
	    ecra << cursor(ecra.cursor().linha() + 1, 0);
	ecra << **i << refresca;
    }
}

int main()
{
    MenuSimples menu_de_sorrisos("Escolha um sorriso :^)",
				 Sorriso::sorrisos, 
				 Sorriso::numero_de_sorrisos);

    list<Glifo*> glifos;

    ecra << refresca;

    while(true) {
	Tecla tecla = teclado.tecla();

	if(tecla.caractere() or tecla == Tecla::ctrl_s) {
	    if(tecla.caractere())
		glifos.push_back(new Caractere(tecla.comoChar()));
	    else
		glifos.push_back(new Sorriso(menu_de_sorrisos.executa()));

	    if(ecra.cursor().coluna() + glifos.back()->largura() >= 
	       ecra.dimensao().colunas() and 
	       glifos.back()->largura() < ecra.dimensao().colunas())
		ecra << cursor(ecra.cursor().linha() + 1, 0);
	    ecra << *glifos.back() << refresca;
	} else if(tecla == Tecla::ctrl_r)
	    mostra(glifos);
	else if(tecla == Tecla::ctrl_q)
	    return 0;
	else
	    ecra << campainha;
    } 
}
