#ifndef PONTO_H
#define PONTO_H

#include <cmath>

/** Representa pontos no plano.
    @invariant -pi < angulo_ <= pi e 0 <= modulo_. */
class Ponto {
public:
    /** Constri ponto com coordenadas cartesianas dadas.
	@pre V.
	@post x() = x e y() = y. */
    Ponto(double const x, double const y);

    /** Devolve a coordenada x do ponto.
	@pre V.
	@post x = coordenada x do ponto. */
    double x() const;

    /** Devolve a coordenada y do ponto.
	@pre V.
	@post y = coordenada y do ponto. */
    double y() const;

    /** Devolve o mdulo do ponto.
	@pre V.
	@post mdulo = mdulo do ponto. */
    double modulo() const;

    /** Devolve o ngulo do ponto.
	@pre V.
	@post angulo = ngulo do ponto. */
    double angulo() const;

private:
    double modulo_;
    double angulo_;

    /** Indica se a condio invariante se verifica.
	@pre V.
	@post cumpreInvariante = (-pi < angulo_ <= pi e 0 <= modulo_). */
    bool cumpreInvariante() const;
};

// Deveria estar num ficheiro de constantes matemticas:
double const pi = std::atan2(0.0, -1.0);

#include "ponto_impl.H"

#endif // PONTO_H
