#include <cassert>

inline Ponto::Ponto(double const x, double const y)
    : modulo_(std::sqrt(x * x + y * y)), angulo_(std::atan2(y, x))
{
    
    assert(cumpreInvariante());
}

inline double Ponto::x() const
{
    assert(cumpreInvariante());

    return modulo() * cos(angulo());
}

inline double Ponto::y() const
{
    assert(cumpreInvariante());

    return modulo() * sin(angulo());
}

inline double Ponto::modulo() const
{
    assert(cumpreInvariante());

    return modulo_;
}

inline double Ponto::angulo() const
{
    assert(cumpreInvariante());

    return angulo_;
}

inline bool Ponto::cumpreInvariante() const
{
    return -pi < angulo_ and angulo_ <= pi and 0 <= modulo_;
}
