#include "empregado.H"
#include "departamento.H"

Departamento::~Departamento()
{
    assert(cumpreInvariante());

    while(not empregados_.empty()) 
	delete empregados_.front();
}

using namespace std;

#ifdef TESTE

int main()
{
    Departamento* departamento1 = new Departamento("departamento1");
    Departamento* departamento2 = new Departamento("departamento2");

    assert(departamento1->nome() == "departamento1");
    assert(departamento2->nome() == "departamento2");

    assert(not departamento1->temChefe());
    assert(not departamento2->temChefe());

    assert(departamento1->empregados().empty());
    assert(departamento2->empregados().empty());

    Empregado* empregado = new Empregado("Z Barnab", departamento1);

    assert(empregado->nome() == "Z Barnab");
    assert(empregado->departamento() == departamento1);
    assert(not empregado->eChefe());
    
    assert(departamento1->contem(empregado));
    assert(not departamento2->contem(empregado));

    assert(departamento1->empregados().front() == empregado);
    assert(departamento2->empregados().empty());

    empregado->mudaPara(departamento2);

    assert(not departamento1->contem(empregado));
    assert(departamento2->contem(empregado));

    assert(departamento1->empregados().empty());
    assert(departamento2->empregados().front() == empregado);

    Empregado* chefe = new Empregado("Saddam Hussein Jr.", departamento1);
 
    assert(chefe->nome() == "Saddam Hussein Jr.");
    assert(chefe->departamento() == departamento1);
    assert(not chefe->eChefe());

    chefe->promoveAChefe();

    assert(chefe->eChefe());

    assert(departamento1->temChefe());
    assert(not departamento2->temChefe());

    assert(departamento1->chefe() == chefe);

    chefe->mudaPara(departamento2);

    assert(not departamento1->contem(chefe));
    assert(departamento2->contem(chefe));

    assert(departamento1->empregados().empty());
    assert(departamento2->empregados().size() == 2);

    assert(not chefe->eChefe());

    assert(not departamento1->temChefe());
    assert(not departamento2->temChefe());

    chefe->promoveAChefe();

    assert(chefe->eChefe());

    assert(not departamento1->temChefe());
    assert(departamento2->temChefe());

    assert(departamento2->chefe() == chefe);

    delete empregado;

    assert(not departamento2->contem(empregado));

    assert(departamento2->empregados().size() == 1);
    assert(departamento2->empregados().front() == chefe);

    (new Empregado("Tony Blair Sr.", departamento1))->promoveAChefe();
    (new Empregado("George W. Bush", departamento1))->promoveAChefe();

    delete departamento1;
    delete departamento2;
}

#endif // TESTE
