#ifndef DEPARTAMENTO_H
#define DEPARTAMENTO_H

#include <list>

#include "empregado.H"

class Departamento {
public:
    Departamento(std::string const& nome);
    ~Departamento();

    std::string const& nome() const;
    bool temChefe() const;
    bool contem(Empregado* empregado);
    Empregado* chefe() const;
    std::list<Empregado*> const& empregados() const;

private:
    std::string nome_;
    std::list<Empregado*> empregados_;
    Empregado* chefe_;

    void colocaComoChefe(Empregado* const novo_chefe);
    void removeChefe();

    void atribui(Empregado* const novo_empregado);
    void remove(Empregado* const empregado);

    bool cumpreInvariante() const;

    friend class Empregado;
};

#include "departamento_impl.H"

#endif // DEPARTAMENTO_H
