#include <cassert>
#include <algorithm>

inline Departamento::Departamento(std::string const& nome)
    : nome_(nome), chefe_(0)
{

    assert(cumpreInvariante());
}

inline std::string const& Departamento::nome() const
{
    assert(cumpreInvariante());

    return nome_;
}

inline bool Departamento::temChefe() const
{
    assert(cumpreInvariante());

    return chefe_ != 0;
}

inline bool Departamento::contem(Empregado* empregado)
{
    assert(cumpreInvariante());

    return find(empregados().begin(), empregados().end(), empregado) !=
	empregados().end();
}

inline Empregado* Departamento::chefe() const
{
    assert(cumpreInvariante());
    assert(temChefe());
    
    return chefe_;
}

inline std::list<Empregado*> const& Departamento::empregados() const
{
    assert(cumpreInvariante());

    return empregados_;
}

inline void Departamento::colocaComoChefe(Empregado* const novo_chefe)
{
    assert(cumpreInvariante());
    assert(not temChefe());
    
    chefe_ = novo_chefe;

    assert(cumpreInvariante());
}

inline void Departamento::removeChefe()
{
    assert(cumpreInvariante());
    assert(temChefe());

    chefe_ = 0;

    assert(cumpreInvariante());
}

inline void Departamento::atribui(Empregado* const novo_empregado)
{
    assert(cumpreInvariante());
    assert(not contem(novo_empregado));

    empregados_.push_back(novo_empregado);

    assert(cumpreInvariante());
}

inline void Departamento::remove(Empregado* const empregado)
{
    assert(cumpreInvariante());
    assert(contem(empregado) and chefe_ != empregado);

    empregados_.remove(empregado);

    assert(cumpreInvariante());
}

inline bool Departamento::cumpreInvariante() const
{
    return chefe_ == 0 or 
	find(empregados_.begin(), empregados_.end(), chefe_) != 
	empregados_.end();
}
