#include "empregado.H"
#include "departamento.H"

using namespace std;

Empregado::Empregado(std::string const& nome, Departamento* departamento)
    : nome_(nome), departamento_(departamento), e_chefe(false)
{
    assert(departamento != 0);

    departamento->atribui(this);

    assert(cumpreInvariante());
}

Empregado::~Empregado()
{
    assert(cumpreInvariante());

    if(eChefe())
	despromove();

    departamento()->remove(this);
}

void Empregado::mudaPara(Departamento* novo_departamento)
{
    assert(cumpreInvariante());
    assert(novo_departamento != 0);
    
    if(eChefe())
	despromove();

    departamento()->remove(this);

    departamento_ = novo_departamento;

    departamento()->atribui(this);

    assert(cumpreInvariante());
}

void Empregado::promoveAChefe()
{
    assert(cumpreInvariante());
    assert(not eChefe());
    
    if(departamento()->temChefe())
	departamento()->chefe()->despromove();

    e_chefe = true;
    departamento()->colocaComoChefe(this);

    assert(cumpreInvariante());
}

void Empregado::despromove()
{
    assert(cumpreInvariante());
    assert(eChefe());

    e_chefe = false;
    departamento()->removeChefe();

    assert(cumpreInvariante());
}

