#include "matriz.H"

bool operator==(Matriz const& a, Matriz const& b) 
{
    for(int i = 0; i != Matriz::N; ++i)
        if(a.elementos[i] != b.elementos[i])
            return false;
    return true;
}

bool operator<(Matriz const& a, Matriz const& b) 
{
    for(int i = 0; i != Matriz::N; ++i)
        if(a.elementos[i] < b.elementos[i])
            return true;
        else if(a.elementos[i] > b.elementos[i])
            return false;
    return false;
}


#ifdef TESTE

int main()
{
    Matriz m = {0, 1, 2};

    assert(m.tamanho() == 10);

    for(int i = 0; i != m.tamanho(); ++i)
        assert(i < 3 ? m[i] == i : m[i] == 0);

    {
	int i = 0;
	for(int* pm = m; pm != m + m.tamanho(); ++pm, ++i)
	    assert(i < 3 ? *pm == i : *pm == 0);
    }

    Matriz const mc(m);

    for(int i = 0; i != mc.tamanho(); ++i)
        assert(i < 3 ? mc[i] == i : mc[i] == 0);    

    {
	int i = 0;
	for(int const* pmc = mc; pmc != mc + mc.tamanho(); ++pmc, ++i)
	    assert(i < 3 ? *pmc == i : *pmc == 0);
    }

    assert(m == mc);
    assert(not (m != mc));

    assert(m <= mc);
    assert(m >= mc);
    assert(not (m < mc));
    assert(not (m > mc));

    m[0] = 4;

    assert(m != mc);
    assert(not (m == mc));

    assert(not (m <= mc));
    assert(m >= mc);
    assert(not (m < mc));
    assert(m > mc);

    m[0] = -1;

    assert(m != mc);
    assert(not (m == mc));

    assert(m <= mc);
    assert(not (m >= mc));
    assert(m < mc);
    assert(not (m > mc));
}

#endif
