#include <cassert>

inline Matriz::operator E const*() const 
{
    assert(cumpreInvariante());

    return elementos;
}

inline Matriz::E const& Matriz::operator[](int const indice) const 
{
    assert(cumpreInvariante());
    assert(0 <= indice and indice < N);

    return elementos[indice];
}

inline int Matriz::tamanho() const 
{
    assert(cumpreInvariante());

    return N;
}

inline Matriz::operator E*() 
{
    assert(cumpreInvariante());

    return elementos;
}

inline Matriz::E& Matriz::operator[](int const indice) 
{
    assert(cumpreInvariante());
    assert(0 <= indice and indice < N);

    return elementos[indice];
}

inline bool Matriz::cumpreInvariante() const
{
    return true;
}

inline bool operator!=(Matriz const& a, Matriz const& b) 
{
    return not (a == b);
}

inline bool operator>(Matriz const& a, Matriz const& b) 
{
    return b < a;
}

inline bool operator<=(Matriz const& a, Matriz const& b) 
{
    return not (a > b);
}

inline bool operator>=(Matriz const& a, Matriz const& b) 
{
    return not (a < b);
}

