#ifndef MATRIZ_H
#define MATRIZ_H

/** Representa matrizes de dimenso fixa.  Substitui as matrizes clssicas do
    C++.  Tem todas as vantagens sem nenhum dos problemas destas!

    Para se poder usar a inicializao das matrizes clssicas esta
    classe no tem membros privados nem construtores.

    Uma matriz clssica  interpretada numa expresso como um
    ponteiro para o primeiro elemento.  Para reproduzir esse
    comportamento define-se um operador de converso.  Als,
    definem-se dois, consoante a matriz seja constante ou no.
    
    Para permitir inicializar uma Matriz com uma lista de
    inicializadores, tal como se faz no caso das matrizes clssicas
    do C++,  necessrio que o atributo que guarda os elementos da
    matriz seja pblico.  
    
     natural que o compilador avise dizendo que faltam chavetas
    numa inicializao.  No se preocupe.  Se fizer muito empenho
    em eliminar os avisos, use dois pares de chavetas em vez de
    apenas um.

    Ver:
      Mathew H. Austern, "Generic Programming and the STL",
      Addison-Wesley, Reading-Massachusetts, 1999. 
      
    @param E tipo do elemento.
    @param N dimenso da matriz. 

    @invariant V. */
template <typename E, int const N>
struct Matriz {

    // Inspectores:

    /** Operador de converso da matriz num ponteiro para o primeiro
	elemento.
	@pre V.
	@post operator E const* = &(*this)[0]. */
    operator E const*() const;

    /** Operador de indexao.
	@pre 0 <= indice < tamanho().
	@post operator[] = elemento indice da matriz. */
    E const& operator[](int const indice) const;

    /** Devolve a dimenso da matriz.
	@pre V.
	@post tamanho() = N. */
    int tamanho() const;


    // Modificadores:

    /** Operador de converso da matriz num ponteiro para o primeiro
	elemento.
	@pre V.
	@post operator E* = &(*this)[0]. */
    operator E*();

    /** Operador de indexao.
	@pre 0 <= indice < tamanho().
	@post operator[] = elemento indice da matriz. */
    E& operator[](int i);

    
    // Atributos:
    
    E elementos[N];

    /** Indica se a condio invariante de classe se verifica.
	@pre V.
	@post V. */
    bool cumpreInvariante() const;
};

/* Ao contrrio das matrizes clssicas do C++, estas matrizes podem-se
   comparar. */

/** Indica se as matrizes a e b so iguais.
    @pre V.
    @post operator== = (Q i : 0 <= i < N : a[i] == b[i]). */
template <typename E, int const N>
bool operator==(Matriz<E, N> const& a, Matriz<E, N> const& b);

/** Indica se as matrizes a e b so diferentes.
    @pre V.
    @post operator!= = (E i : 0 <= i < N : a[i] <> b[i]). */
template <typename E, int const N>
bool operator!=(Matriz<E, N> const& a, Matriz<E, N> const& b);

/** Indica se a matriz a  menor que a matriz b.
    @pre V.
    @post operator< = 
        (E i : 0 <= i < N : (Q j : 0 <= j < N : a[i] = b[i]) e a[i] < b[i]). */
template <typename E, int const N>
bool operator<(Matriz<E, N> const& a, Matriz<E, N> const& b);

/** Indica se a matriz a  maior que a matriz b.
    @pre V.
    @post operator> = b < a. */
template <typename E, int const N>
bool operator>(Matriz<E, N> const& a, Matriz<E, N> const& b);

/** Indica se a matriz a  menor ou igual  matriz b.
    @pre V.
    @post operator<= = (a > b). */
template <typename E, int const N>
bool operator<=(Matriz<E, N> const& a, Matriz<E, N> const& b);

/** Indica se a matriz a  maior ou igual  matriz b.
    @pre V.
    @post operator<= = (a < b). */
template <typename E, int const N>
bool operator>=(Matriz<E, N> const& a, Matriz<E, N> const& b);

#include "matriz_impl.H"

#endif // MATRIZ_H
