#include <cassert>

template <typename E, int const N>
inline Matriz<E, N>::operator E const*() const 
{
    assert(cumpreInvariante());

    return elementos;
}

template <typename E, int const N>
inline E const& Matriz<E, N>::operator[](int const indice) const 
{
    assert(cumpreInvariante());
    assert(0 <= indice and indice < N);

    return elementos[indice];
}

template <typename E, int const N>
inline int Matriz<E, N>::tamanho() const 
{
    assert(cumpreInvariante());

    return N;
}

template <typename E, int const N>
inline Matriz<E, N>::operator E*() 
{
    assert(cumpreInvariante());

    return elementos;
}

template <typename E, int const N>
inline E& Matriz<E, N>::operator[](int const indice) 
{
    assert(cumpreInvariante());
    assert(0 <= indice and indice < N);

    return elementos[indice];
}

template <typename E, int const N>
inline bool Matriz<E, N>::cumpreInvariante() const
{
    return true;
}

template <typename E, int const N>
inline bool operator!=(Matriz<E, N> const& a, Matriz<E, N> const& b) 
{
    return not (a == b);
}

template <typename E, int const N>
inline bool operator>(Matriz<E, N> const& a, Matriz<E, N> const& b) 
{
    return b < a;
}

template <typename E, int const N>
inline bool operator<=(Matriz<E, N> const& a, Matriz<E, N> const& b) 
{
    return not (a > b);
}

template <typename E, int const N>
inline bool operator>=(Matriz<E, N> const& a, Matriz<E, N> const& b) 
{
    return not (a < b);
}

/* Se a palavra chave export funcionasse estes operadores deveriam estar
   definidos no ficheiro de implementao (matriz.C). */

/*export*/ template <typename E, int const N>
bool operator==(Matriz<E, N> const& a, Matriz<E, N> const& b) 
{
    for(int i = 0; i != N; ++i)
        if(a.elementos[i] != b.elementos[i])
            return false;
    return true;
}

/*export*/ template <typename E, int const N>
bool operator<(Matriz<E, N> const& a, Matriz<E, N> const& b) 
{
    for(int i = 0; i != N; ++i)
        if(a.elementos[i] < b.elementos[i])
            return true;
        else if(a.elementos[i] > b.elementos[i])
            return false;
    return false;
}

