#include "circunferencia.H"

#include <cmath>

#include "util.H"

/* Desenha o circunferncia compensando pxeis com relao largura/altura
   quadro.aspecto() do quadro quadro.   uma implementao nave.  Ver bons
   livros de computao grfica para melhores mtodos. */
void Circunferencia::desenhaEm(Quadro& quadro) const 
{
    assert(cumpreInvariante());

    // Posio do circunferncia:
    int l = posicao().linha();
    int c = posicao().coluna();
    double aspecto = quadro.aspecto();

    if(aspecto <= 1.0) {
        // Tamanho do ciclo de colunas para meio semi-circunferncia:
        int meio = arredonda<int>(raio() /
                                  sqrt(quadrado(aspecto) + 1));
        // Ciclo de colunas ("quartos" de circunferncia superior e inferior):
        for(int i = - meio; i != meio + 1; ++i) {
            Posicao ps(l - arredonda<int>(aspecto * sqrt(quadrado(raio())
                                                         - quadrado(i))),
                       c + i);
            quadro.pinta(ps);
            Posicao pi(l + arredonda<int>(aspecto * sqrt(quadrado(raio())
                                                         - quadrado(i))),
                       c + i);
            quadro.pinta(pi);
        }
        // Ciclo de linhas ("quartos" de circunferncia esquerdo e direito):
        for(int i = - arredonda<int>(aspecto * meio);
            i != arredonda<int>(aspecto * meio) + 1; ++i) {
            Posicao pe(l + i,
                       c - arredonda<int>(sqrt(quadrado(raio()) -
                                               quadrado(i / aspecto))));
            quadro.pinta(pe);
            Posicao pd(l + i,
                       c + arredonda<int>(sqrt(quadrado(raio()) -
                                               quadrado(i / aspecto))));
            quadro.pinta(pd);
        }
    } else {
        // Tamanho do ciclo de linhas para meio semi-circunferncia:
        int meio = arredonda<int>(raio() * quadrado(aspecto) /
                                  sqrt(quadrado(aspecto) + 1));
        // Ciclo de linhas ("quartos" de circunferncia esquerdo e direito):
        for(int i = - meio; i != meio + 1; ++i) {
            Posicao pe(l + i,
                       c - arredonda<int>(sqrt(quadrado(raio())
                                               - quadrado(i / aspecto))));
            quadro.pinta(pe);
            Posicao pd(l + i,
                       c + arredonda<int>(sqrt(quadrado(raio())
                                               - quadrado(i / aspecto))));
            quadro.pinta(pd);
        }
        // Ciclo de colunas ("quartos" de circunferncia superior e inferior):
        for(int i = - arredonda<int>(meio / aspecto);
            i != arredonda<int>(meio / aspecto) + 1; ++i) {
            Posicao ps(l - arredonda<int>(aspecto*sqrt(quadrado(raio())
                                                       - quadrado(i))),
                       c + i);
            quadro.pinta(ps);
            Posicao pi(l + arredonda<int>(aspecto*sqrt(quadrado(raio())
                                                       - quadrado(i))),
                       c + i);
            quadro.pinta(pi);
        }
    }
}
