#ifndef CIRCUNFERENCIA_H
#define CIRCUNFERENCIA_H

#include "forma.H"

/** Representa uma circunferncia.  Posio  o centro.
    @invariant 0 <= raio_. */
class Circunferencia : public Forma {
public:
    /** Constri uma circunferncia, dadas a posio e a dimenso do
	raio (em colunas do quadro).
	@pre 0 <= raio.
	@post posicao() = posicao e raio() = raio. */
    Circunferencia(Posicao const& posicao, int raio);

    /** Destrutor virtual.  Garante que os destrutores das classes
        derivadas so invocados mesmo atravs dum ponteiro para a
        classe Circunferencia.
        @pre V. */
    ~Circunferencia() {}

    /** Devolve dimenso do raio em colunas do quadro.
	@pre V.
	@post raio = raio da circunferncia. */
    int raio() const;

    /** Desenha o circunferncia no quadro, compensando o facto dos
	pxeis serem rectangulares.
	@pre V.
	@post quadro est pintado na zona correspondente  circunferncia. */
    virtual void desenhaEm(Quadro& quadro) const;

private:
    // Dimenso do raio (em colunas):
    int raio_;

    /** Indica se a condio invariante de classe se verifica.
	@pre V.
	@post cumpreInvariante = 0 <= raio_. */
    bool cumpreInvariante() const;
};

#include "circunferencia_impl.H"

#endif // CIRCUNFERENCIA_H
